/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.web.UrlBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyException;
import net.savignano.snotify.confluence.mailer.security.SnotifyPgpKey;
import net.savignano.snotify.confluence.mailer.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyLoader {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyLoader.class);
    private final String keyServer;
    private final String email;
    private int timeout = 20000;

    public PgpPublicKeyLoader(String keyServer, String email) {
        this.keyServer = keyServer;
        this.email = email;
        if (keyServer == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    public SnotifyPgpKey loadKey() {
        try {
            log.info("Looking up public key for email " + this.getEmail() + " from: " + this.keyServer);
            String keyId = this.getKeyIdFromServer(this.keyServer, "<" + this.getEmail() + ">");
            if (keyId != null) {
                PGPPublicKeyRingCollection keysFromServer = this.getKeyFromServer(this.keyServer, keyId);
                return new SnotifyPgpKey(keysFromServer, this.getEmail());
            }
        }
        catch (IOException | KeyException | PGPException e) {
            log.warn("Error retrieving public key from keyserver for email: " + this.getEmail(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyIdFromServer(String baseUrl, String searchFor) throws IOException {
        HttpURLConnection connection = this.createConnection(baseUrl, searchFor, "index");
        log.debug("Connecting to: {}", (Object)connection.getURL());
        connection.connect();
        if (connection.getResponseCode() == 404) {
            log.info("No public key found for: {}", (Object)searchFor);
            return null;
        }
        try (InputStream is = connection.getInputStream();){
            long currentTime = System.currentTimeMillis() / 1000L;
            String keyId = null;
            boolean skipToNextKey = false;
            String encoding = connection.getContentEncoding();
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
            while (true) {
                if (lineIterator.hasNext()) {
                    String[] parts;
                    String line = StringEscapeUtils.unescapeHtml((String)lineIterator.nextLine());
                    log.debug(line);
                    if (line.startsWith("pub:")) {
                        skipToNextKey = true;
                        keyId = null;
                        parts = line.split(":", 7);
                        if (parts.length != 7) continue;
                        keyId = parts[1];
                        String expirationDate = parts[5];
                        String flags = parts[6];
                        boolean validKey = flags.isEmpty() || expirationDate.isEmpty() || Long.parseLong(expirationDate) > currentTime;
                        skipToNextKey = !validKey;
                        continue;
                    }
                    if (skipToNextKey || !line.startsWith("uid:") || (parts = line.split(":", 5)).length != 5 || !parts[1].contains(searchFor)) continue;
                    log.info("Found matching public key for {} with ID: {}", (Object)searchFor, (Object)keyId);
                    String string = keyId;
                    return string;
                    continue;
                }
                break;
            }
        }
        finally {
            connection.disconnect();
        }
        log.info("No public key found for: {}", (Object)searchFor);
        return null;
    }

    /*
     * Loose catch block
     */
    private PGPPublicKeyRingCollection getKeyFromServer(String baseUrl, String keyId) throws IOException, PGPException {
        HttpURLConnection connection = this.createConnection(baseUrl, "0x" + keyId, "get");
        log.debug("Connecting to: {}", (Object)connection.getURL());
        connection.connect();
        if (connection.getResponseCode() == 404) {
            log.debug("No public key found with ID: {}", (Object)keyId);
            return null;
        }
        try {
            try (InputStream is = connection.getInputStream();){
                PGPPublicKeyRingCollection pGPPublicKeyRingCollection = PgpUtil.getPublicCollection(IOUtils.toByteArray((InputStream)is));
                return pGPPublicKeyRingCollection;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private HttpURLConnection createConnection(String baseUrl, String searchFor, String operation) throws IOException {
        String basePath = "pks/lookup";
        String searchArg = "search";
        String operationArg = "op";
        String optionsArg = "options";
        String exactArg = "exact";
        UrlBuilder builder = new UrlBuilder(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "pks/lookup");
        builder.add("search", searchFor);
        builder.add("op", operation);
        builder.add("options", "mr");
        builder.add("exact", "on");
        URL url = new URL(builder.toUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(false);
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        return connection;
    }

    public String getKeyServerUrl() {
        return this.keyServer;
    }

    public String getEmail() {
        return this.email;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

