/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpKey {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpKey.class);
    private final PGPPublicKeyRing ring;

    public SnotifyPgpKey(PGPPublicKeyRingCollection collection, String email) throws KeyException {
        if (collection == null) {
            throw new IllegalArgumentException("Key ring collection must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email address must not be null.");
        }
        PGPPublicKeyRing matchedRing = null;
        Iterator<PGPPublicKeyRing> iterRing = collection.iterator();
        block0: while (iterRing.hasNext() && matchedRing == null) {
            PGPPublicKeyRing ring = iterRing.next();
            for (PGPPublicKey key : ring) {
                long keyId = key.getKeyID();
                String prettyKeyId = Long.toHexString(keyId).toUpperCase();
                if (!key.isMasterKey()) continue;
                Iterator<String> iter = key.getUserIDs();
                while (iter.hasNext()) {
                    if (!iter.next().toLowerCase().contains(email)) continue;
                    log.debug("Found valid key (ID: {}) for encryption.", (Object)prettyKeyId);
                    matchedRing = ring;
                    break;
                }
                if (!log.isDebugEnabled()) continue block0;
                ArrayList<String> ids = new ArrayList<String>();
                Iterator<String> iter2 = key.getUserIDs();
                while (iter2.hasNext()) {
                    ids.add(iter2.next());
                }
                if (ids.isEmpty()) {
                    log.debug("Key with ID {} does not contain any user IDs.", (Object)prettyKeyId);
                    continue block0;
                }
                log.debug("Key with ID {} had the following user IDs: {}", (Object)prettyKeyId, ids);
                continue block0;
            }
        }
        if (matchedRing == null) {
            throw new KeyManagementException("No matching PGP public key found for email adress: " + email);
        }
        this.ring = matchedRing;
    }

    public SnotifyPgpKey(PGPPublicKeyRing ring) {
        if (ring == null) {
            throw new IllegalArgumentException("Key ring must not be null.");
        }
        this.ring = ring;
    }

    public PGPPublicKey getMasterKey() {
        for (PGPPublicKey key : this.ring) {
            if (!key.isMasterKey()) continue;
            return key;
        }
        throw new IllegalStateException("No master key found in public ring.");
    }

    public PGPPublicKey getEncryptionKey() {
        for (PGPPublicKey key : this.ring) {
            boolean valid;
            long keyId = key.getKeyID();
            String prettyKeyId = Long.toHexString(keyId).toUpperCase();
            if (!key.isEncryptionKey()) {
                log.debug("Algorithm for key with ID {} can not be used for encryption.", (Object)prettyKeyId);
                continue;
            }
            boolean keyFlagsUsed = false;
            boolean encryptionFlag = false;
            Iterator signatures = key.getSignatures();
            while (signatures.hasNext()) {
                PGPSignature signature = (PGPSignature)signatures.next();
                PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
                if (packets == null) continue;
                int keyFlags = packets.getKeyFlags();
                boolean bl = keyFlagsUsed = keyFlagsUsed || keyFlags != 0;
                if ((keyFlags & 4) == 0) continue;
                encryptionFlag = true;
                break;
            }
            if (!encryptionFlag && keyFlagsUsed) {
                log.debug("Key with ID {} has not the necessary flags for an encryption key.", (Object)prettyKeyId);
                continue;
            }
            if (key.hasRevocation()) {
                log.debug("Key with ID {} has been revoked.", (Object)prettyKeyId);
                continue;
            }
            long validSeconds = key.getValidSeconds();
            boolean bl = valid = validSeconds == 0L || key.getCreationTime().getTime() + validSeconds >= System.currentTimeMillis();
            if (!valid) {
                log.debug("Key with ID {} is no loger valid.", (Object)prettyKeyId);
                continue;
            }
            log.debug("Key with ID {} can be used for encryption.", (Object)prettyKeyId);
            return key;
        }
        log.debug("No key found that can be used for encryption");
        return null;
    }

    public PGPPublicKey getKey(long keyId) {
        return this.ring.getPublicKey(keyId);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.ring.encode(baos, true);
        return baos.toByteArray();
    }
}

