/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import net.savignano.snotify.confluence.mailer.Mailer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final ApplicationPropertiesUtil appUtil = new ApplicationPropertiesUtil();
    private static final UserPropertiesUtil userUtil = new UserPropertiesUtil();

    public static final ApplicationPropertiesUtil getAppProps() {
        return appUtil;
    }

    public static final UserPropertiesUtil getUserProps() {
        return userUtil;
    }

    public static class UserPropertiesUtil {
        private static final String SETTINGS_STRING_EXISTS = ".exists";
        private static final String SETTINGS_STRING_PAGES = ".pages";
        private static final String SETTINGS_STRING_PAGE = ".page.";

        public String getString(String key, User user) {
            String value;
            try {
                value = this.getPrefs(user).getString(key);
            }
            catch (PropertyException e) {
                log.error("Property exception loading property " + key + " for user " + user + ".", (Throwable)e);
                return null;
            }
            catch (ClassCastException e) {
                log.error("ClassCastException loading property " + key + " for user " + user + ".", (Throwable)e);
                return null;
            }
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }

        public String getUnlimitedString(String key, User user) {
            if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, user)) {
                return null;
            }
            Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
            if (pagesValue == null) {
                return null;
            }
            int pages = pagesValue.intValue();
            StringBuilder builder = new StringBuilder(255 * pages);
            for (int i = 0; i < pages; ++i) {
                String page = this.getString(key + SETTINGS_STRING_PAGE + i, user);
                builder.append(page);
            }
            String value = builder.toString();
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }

        public boolean getBoolean(String key, User user) {
            return this.getBoolean(key, false, user);
        }

        public boolean getBoolean(String key, boolean defaultValue, User user) {
            String value = this.getString(key, user);
            if (value == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        public Long getLong(String key, User user) {
            String value = this.getString(key, user);
            if (value != null) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    log.error("Value " + value + " stored in user property " + key + " for user " + user + " is not a Long.", (Throwable)e);
                }
            }
            return null;
        }

        public <T extends Enum<T>> T getEnum(String key, Class<T> clazz, User user) {
            String value = this.getString(key, user);
            if (value != null) {
                try {
                    return Enum.valueOf(clazz, value);
                }
                catch (IllegalArgumentException e) {
                    log.error("Value " + value + " stored in application property " + key + " for user " + user + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
                }
            }
            return null;
        }

        public byte[] getBytes(String key, User user) {
            String base64Value = this.getUnlimitedString(key, user);
            if (base64Value != null) {
                return Base64.decodeBase64((byte[])base64Value.getBytes(Mailer.UTF8_CHARSET));
            }
            return null;
        }

        public void setString(String key, String value, User user) {
            boolean stringExists = true;
            boolean validString = true;
            try {
                UserPreferences prefs = this.getPrefs(user);
                try {
                    stringExists = prefs.getString(key) != null;
                }
                catch (Exception e) {
                    log.debug("Property " + key + " for user " + user + " isn't stored as string.", (Throwable)e);
                    validString = false;
                }
                if (value == null && stringExists || !validString) {
                    prefs.remove(key);
                }
                if (value != null) {
                    prefs.setString(key, value);
                }
            }
            catch (AtlassianCoreException | PropertyException e) {
                log.error("Property exception setting property " + key + " for user " + user + ".", e);
            }
        }

        public void setUnlimitedString(String key, String value, User user) {
            this.removeUnlimitedString(key, user);
            if (value != null) {
                int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
                if (pages > 0) {
                    for (int i = 0; i < pages - 1; ++i) {
                        this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255), user);
                    }
                    this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255), user);
                }
                this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages), user);
                this.setBoolean(key + SETTINGS_STRING_EXISTS, true, user);
            }
        }

        private void removeUnlimitedString(String key, User user) {
            if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, user)) {
                return;
            }
            Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
            if (pagesValue == null) {
                return;
            }
            this.setString(key + SETTINGS_STRING_EXISTS, null, user);
            this.setLong(key + SETTINGS_STRING_PAGES, null, user);
            int pages = pagesValue.intValue();
            for (int i = 0; i < pages; ++i) {
                this.setString(key + SETTINGS_STRING_PAGE + i, null, user);
            }
        }

        public void setBoolean(String key, boolean value, User user) {
            this.setString(key, String.valueOf(value), user);
        }

        public void setLong(String key, Long value, User user) {
            this.setString(key, value == null ? null : value.toString(), user);
        }

        public void setEnum(String key, Enum<?> value, User user) {
            this.setString(key, value == null ? null : value.name(), user);
        }

        public void setBytes(String key, byte[] value, User user) {
            String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Mailer.UTF8_CHARSET);
            this.setUnlimitedString(key, encoded, user);
        }

        private UserPreferences getPrefs(User user) {
            if (user == null) {
                throw new PropertyException("Can't get user preferences for 'null' user.");
            }
            return ((UserAccessor)ComponentLocator.getComponent(UserAccessor.class)).getConfluenceUserPreferences(user).getWrappedPreferences();
        }
    }

    public static class ApplicationPropertiesUtil {
        private static final String SETTINGS_STRING_EXISTS = ".exists";
        private static final String SETTINGS_STRING_PAGES = ".pages";
        private static final String SETTINGS_STRING_PAGE = ".page.";

        public String getString(String key) {
            String value;
            try {
                value = (String)this.getProps().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            }
            catch (ClassCastException e) {
                log.error("ClassCastException loading application property " + key + ".", (Throwable)e);
                return null;
            }
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }

        public String getUnlimitedString(String key) {
            if (!this.getBoolean(key + SETTINGS_STRING_EXISTS)) {
                return null;
            }
            Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES);
            if (pagesValue == null) {
                return null;
            }
            int pages = pagesValue.intValue();
            StringBuilder builder = new StringBuilder(255 * pages);
            for (int i = 0; i < pages; ++i) {
                String page = this.getString(key + SETTINGS_STRING_PAGE + i);
                builder.append(page);
            }
            String value = builder.toString();
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }

        public boolean getBoolean(String key) {
            return this.getBoolean(key, false);
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            String value = this.getString(key);
            if (value == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        public Long getLong(String key) {
            String value = this.getString(key);
            if (value != null) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    log.error("Value " + value + " stored in application property " + key + " is not a Long.", (Throwable)e);
                }
            }
            return null;
        }

        public <T extends Enum<T>> T getEnum(String key, Class<T> clazz) {
            String value = this.getString(key);
            if (value != null) {
                try {
                    return Enum.valueOf(clazz, value);
                }
                catch (IllegalArgumentException e) {
                    log.error("Value " + value + " stored in application property " + key + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
                }
            }
            return null;
        }

        public byte[] getBytes(String key) {
            String base64Value = this.getUnlimitedString(key);
            if (base64Value != null) {
                return Base64.decodeBase64((byte[])base64Value.getBytes(Mailer.UTF8_CHARSET));
            }
            return null;
        }

        public void setString(String key, String value) {
            BandanaManager props = this.getProps();
            Object oldValue = props.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            if (!(oldValue == null || value != null && oldValue instanceof String)) {
                props.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            }
            if (value != null) {
                props.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key, (Object)value);
            }
        }

        public void setUnlimitedString(String key, String value) {
            this.removeUnlimitedString(key);
            if (value != null) {
                int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
                if (pages > 0) {
                    for (int i = 0; i < pages - 1; ++i) {
                        this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255));
                    }
                    this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255));
                }
                this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages));
                this.setBoolean(key + SETTINGS_STRING_EXISTS, true);
            }
        }

        private void removeUnlimitedString(String key) {
            if (!this.getBoolean(key + SETTINGS_STRING_EXISTS)) {
                return;
            }
            Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES);
            if (pagesValue == null) {
                return;
            }
            this.setString(key + SETTINGS_STRING_EXISTS, null);
            this.setLong(key + SETTINGS_STRING_PAGES, null);
            int pages = pagesValue.intValue();
            for (int i = 0; i < pages; ++i) {
                this.setString(key + SETTINGS_STRING_PAGE + i, null);
            }
        }

        public void setBoolean(String key, boolean value) {
            this.setString(key, String.valueOf(value));
        }

        public void setLong(String key, Long value) {
            this.setString(key, value == null ? null : value.toString());
        }

        public void setEnum(String key, Enum<?> value) {
            this.setString(key, value == null ? null : value.name());
        }

        public void setBytes(String key, byte[] value) {
            String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Mailer.UTF8_CHARSET);
            this.setUnlimitedString(key, encoded);
        }

        private BandanaManager getProps() {
            return (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        }
    }
}

