/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.enums.EncryptionKeySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailEncryptor<T> {
    private static final long EXPIRE_DURATION = 43200000L;
    private static final Logger log = LoggerFactory.getLogger(AbstractMailEncryptor.class);
    private final Session session;
    private final Address address;
    private final MimeMessage message;
    private User user;
    private String hostName;
    private T publicKey;

    private static final User getUserForAddress(Address address) {
        String email = address.toString();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        SearchResult searchResult = userAccessor.getUsersByEmail(email);
        Iterator users = searchResult.pager().iterator();
        if (users.hasNext()) {
            User user = (User)users.next();
            log.debug("Found user {} for email \"{}\".", (Object)user, (Object)email);
            if (users.hasNext()) {
                ArrayList<Object> logUsers = new ArrayList<Object>();
                logUsers.add(user);
                while (users.hasNext()) {
                    logUsers.add(users.next());
                }
                log.warn("Multiple users found for email \"{}\". First user found used for encryption purposes, but this can be unpredictable: {}", (Object)email, logUsers);
            }
            return user;
        }
        log.error("No user found for email: {}", (Object)email);
        return null;
    }

    public AbstractMailEncryptor(Session session, MimeMessage message, Address address) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message must not be null.");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address must not be null.");
        }
        this.session = session;
        this.message = message;
        this.address = address;
        this.setHostName("<Unknown>");
    }

    public MimeMessage getEncryptedMessage() throws IOException, MessagingException {
        if (this.getPublicKey() == null) {
            throw new MessagingException("No public key found for address: " + this.address);
        }
        return this.encrypt();
    }

    protected abstract MimeMessage encrypt() throws IOException, MessagingException;

    protected T loadPublicKey() {
        if (this.getUser() == null) {
            return null;
        }
        EncryptorPropertiesData data = this.getPropertiesData();
        log.debug("Used properties for determining validity of key: {}", (Object)data);
        if (log.isTraceEnabled()) {
            log.trace("Used properties for determining validity of key (verbose): {}", (Object)data.toString(false));
        }
        boolean exceptionHappened = false;
        boolean validKey = false;
        T publicKey = null;
        try {
            publicKey = this.getUserPublicKey();
            validKey = this.isPublicKeyValid(publicKey);
        }
        catch (Exception e) {
            log.error("Public key could not be retrieved from user " + this.getUser() + ": " + e.getMessage(), (Throwable)e);
            exceptionHappened = true;
        }
        boolean isGetRepositoryKey = false;
        if (exceptionHappened) {
            isGetRepositoryKey = true;
        } else if (validKey) {
            isGetRepositoryKey = data.keySource == EncryptionKeySource.USER ? !data.allowCustomUserKey : data.expireTimeStamp != null && (data.timeStamp == null || data.expireTimeStamp > data.timeStamp);
            log.debug("Does valid key from source {} need to be loaded from repository: {}", (Object)data.keySource, (Object)isGetRepositoryKey);
        } else {
            isGetRepositoryKey = data.timeStamp == null || System.currentTimeMillis() > data.timeStamp + 43200000L || data.expireTimeStamp != null && data.expireTimeStamp > data.timeStamp;
            log.debug("Does invalid key need to be loaded from repository: {}", (Object)isGetRepositoryKey);
        }
        if (isGetRepositoryKey) {
            try {
                publicKey = this.getRepositoryPublicKey();
                validKey = this.isPublicKeyValid(publicKey);
            }
            catch (Exception e) {
                log.error("Public key could not be retrieved from repository for user " + this.getUser() + ": " + e.getMessage(), (Throwable)e);
                exceptionHappened = true;
            }
            if (!exceptionHappened) {
                log.debug("Storing new public key to user properties: {}", publicKey);
                try {
                    this.storePublicKey(publicKey);
                }
                catch (IOException e) {
                    log.error("Public key could not be stored for user " + this.getUser() + ". Error message: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (validKey && !exceptionHappened) {
            return publicKey;
        }
        return null;
    }

    protected abstract T getRepositoryPublicKey() throws Exception;

    protected abstract T getUserPublicKey() throws Exception;

    protected abstract boolean isPublicKeyValid(T var1);

    protected abstract void storePublicKey(T var1) throws IOException;

    protected abstract EncryptorPropertiesData getPropertiesData();

    public T getPublicKey() {
        if (this.publicKey == null) {
            this.setPublicKey(this.loadPublicKey());
        }
        return this.publicKey;
    }

    public void setPublicKey(T publicKey) {
        this.publicKey = publicKey;
    }

    public Session getSession() {
        return this.session;
    }

    public Address getAddress() {
        return this.address;
    }

    public User getUser() {
        if (this.user == null) {
            this.user = this.loadUser();
        }
        return this.user;
    }

    protected User loadUser() {
        return AbstractMailEncryptor.getUserForAddress(this.getAddress());
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public static class EncryptorPropertiesData {
        public Long expireTimeStamp;
        public Long timeStamp;
        public EncryptionKeySource keySource;
        public boolean allowCustomUserKey;

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean userFriendlyDates) {
            if (userFriendlyDates) {
                return "EncryptorPropertiesData [expireRepositoryData=" + (this.expireTimeStamp == null ? null : new Date(this.expireTimeStamp)) + ", timeStamp=" + (this.timeStamp == null ? null : new Date(this.timeStamp)) + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", currentTime=" + new Date(System.currentTimeMillis()) + "]";
            }
            return "EncryptorPropertiesData [expireRepositoryData=" + this.expireTimeStamp + ", timeStamp=" + this.timeStamp + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", currentTime=" + System.currentTimeMillis() + "]";
        }
    }
}

