/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.web.UrlBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.savignano.snotify.confluence.mailer.security.SnotifyPgpKey;
import net.savignano.snotify.confluence.mailer.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyLoader {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyLoader.class);
    private final String keyServer;
    private final String email;
    private boolean encodeSearchParam = true;
    private int timeout = 20000;
    private Exception exception;

    public PgpPublicKeyLoader(String keyServer, String email) {
        this.keyServer = keyServer;
        this.email = email;
        if (keyServer == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    public SnotifyPgpKey loadKey() {
        log.info("Looking up public key for email {} from: {}", (Object)this.getEmail(), (Object)this.keyServer);
        this.setException(null);
        Set<String> keyIds = this.getKeyIdsFromServer(this.keyServer, "<" + this.getEmail() + ">");
        List<SnotifyPgpKey> keys = this.getKeysFromServer(this.keyServer, keyIds);
        SnotifyPgpKey key = this.getNewestKey(keys);
        if (key == null) {
            log.info("No public key found for email: {}", (Object)this.getEmail());
        } else {
            log.info("Found public key for email {} with ID: {}", (Object)this.getEmail(), (Object)Long.toHexString(key.getMasterKey().getKeyID()).toUpperCase());
        }
        return key;
    }

    private SnotifyPgpKey getNewestKey(Collection<SnotifyPgpKey> keys) {
        if (keys.isEmpty()) {
            return null;
        }
        long newestCreationTime = 0L;
        SnotifyPgpKey newestKey = null;
        for (SnotifyPgpKey key : keys) {
            PGPPublicKey encKey = key.getEncryptionKey();
            if (encKey == null || encKey.getCreationTime().getTime() <= newestCreationTime) continue;
            newestCreationTime = encKey.getCreationTime().getTime();
            newestKey = key;
        }
        if (newestKey != null && log.isDebugEnabled()) {
            PGPPublicKey encKey = newestKey.getEncryptionKey();
            PGPPublicKey masterKey = newestKey.getMasterKey();
            String prettyEncKeyId = Long.toHexString(encKey.getKeyID()).toUpperCase();
            String prettyMasterKeyId = Long.toHexString(masterKey.getKeyID()).toUpperCase();
            log.debug("Most current key (ID: {}, Master Key ID: {}). Creation time: {}", new Object[]{prettyEncKeyId, prettyMasterKeyId, encKey.getCreationTime()});
        }
        return newestKey;
    }

    private List<SnotifyPgpKey> getKeysFromServer(String baseUrl, Collection<String> keyIds) {
        if (keyIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SnotifyPgpKey> keys = new ArrayList<SnotifyPgpKey>();
        for (String keyId : keyIds) {
            PGPPublicKeyRingCollection key = this.getKeyFromServer(baseUrl, keyId);
            if (key == null) continue;
            try {
                SnotifyPgpKey pgpKey = new SnotifyPgpKey(key, this.getEmail());
                keys.add(pgpKey);
            }
            catch (KeyException e) {
                log.warn("Key with ID " + keyId + " does not contain a matching public key for email: " + this.getEmail(), (Throwable)e);
                this.setException(e);
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyIdsFromServer(String baseUrl, String searchFor) {
        HashSet<String> keyIds = new HashSet<String>();
        try {
            HttpURLConnection connection = this.createConnection(baseUrl, searchFor, "index", this.isEncodeSearchParam());
            log.debug("Connecting to: {}", (Object)connection.getURL());
            connection.connect();
            if (connection.getResponseCode() == 404) {
                log.debug("No public key found for: {}", (Object)searchFor);
                return keyIds;
            }
            try (InputStream is = connection.getInputStream();){
                long currentTime = System.currentTimeMillis() / 1000L;
                String keyId = null;
                boolean skipToNextKey = false;
                String encoding = connection.getContentEncoding();
                LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
                while (lineIterator.hasNext()) {
                    String[] parts;
                    String line = StringEscapeUtils.unescapeHtml((String)lineIterator.nextLine());
                    log.trace(line);
                    if (line.startsWith("pub:")) {
                        skipToNextKey = true;
                        keyId = null;
                        parts = line.split(":", 7);
                        if (parts.length != 7) continue;
                        keyId = parts[1];
                        String expirationDate = parts[5];
                        String flags = parts[6];
                        boolean validKey = flags.isEmpty() || expirationDate.isEmpty() || Long.parseLong(expirationDate) > currentTime;
                        skipToNextKey = !validKey;
                        continue;
                    }
                    if (skipToNextKey || !line.startsWith("uid:") || (parts = line.split(":", 5)).length != 5 || !parts[1].contains(searchFor)) continue;
                    log.info("Found matching public key for {} with ID: {}", (Object)searchFor, (Object)keyId);
                    keyIds.add(keyId);
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            log.warn("Error retrieving public key from keyserver for email: " + this.getEmail(), (Throwable)e);
            this.setException(e);
        }
        if (keyIds.isEmpty()) {
            log.debug("No public keys found for: {}", (Object)searchFor);
        } else {
            log.debug("Key IDs found for {}: {}", (Object)searchFor, keyIds);
        }
        return keyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PGPPublicKeyRingCollection getKeyFromServer(String baseUrl, String keyId) {
        log.debug("Looking up pulic key with ID: " + keyId);
        HttpURLConnection connection = null;
        try {
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection;
            Throwable throwable;
            InputStream is;
            block22: {
                block23: {
                    connection = this.createConnection(baseUrl, "0x" + keyId, "get", false);
                    log.debug("Connecting to: {}", (Object)connection.getURL());
                    connection.connect();
                    if (connection.getResponseCode() == 404) {
                        log.debug("No public key found with ID: {}", (Object)keyId);
                        PGPPublicKeyRingCollection pGPPublicKeyRingCollection2 = null;
                        return pGPPublicKeyRingCollection2;
                    }
                    is = connection.getInputStream();
                    throwable = null;
                    pGPPublicKeyRingCollection = PgpUtil.getPublicCollection(IOUtils.toByteArray((InputStream)is));
                    if (is == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                is.close();
            }
            return pGPPublicKeyRingCollection;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (PGPException e) {
                        log.warn("Error reading public key with ID " + keyId + " from keyserver for email: " + this.getEmail(), (Throwable)e);
                        this.setException(e);
                    }
                }
                catch (IOException e) {
                    log.warn("Error retrieving public key with ID " + keyId + " from keyserver for email: " + this.getEmail(), (Throwable)e);
                    this.setException(e);
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private HttpURLConnection createConnection(String baseUrl, String searchFor, String operation, boolean encode) throws IOException {
        String basePath = "pks/lookup";
        String searchArg = "search";
        String operationArg = "op";
        String optionsArg = "options";
        String exactArg = "exact";
        UrlBuilder builder = new UrlBuilder(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "pks/lookup");
        builder.add("op", operation);
        builder.add("options", "mr");
        builder.add("exact", "on");
        StringBuilder builder2 = new StringBuilder(builder.toUrl());
        builder2.append('&');
        builder2.append("search");
        builder2.append('=');
        builder2.append(encode ? URLEncoder.encode(searchFor, "UTF-8") : searchFor);
        URL url = new URL(builder2.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(false);
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        return connection;
    }

    public String getKeyServerUrl() {
        return this.keyServer;
    }

    public String getEmail() {
        return this.email;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isEncodeSearchParam() {
        return this.encodeSearchParam;
    }

    public void setEncodeSearchParam(boolean encodeSearchParam) {
        this.encodeSearchParam = encodeSearchParam;
    }

    public Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }
}

