/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.examples.PGPExampleUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.util.io.Streams;

public class KeyBasedLargeFileProcessor {
    private static void decryptFile(String inputFileName, String keyFileName, char[] passwd, String defaultFileName) throws IOException, NoSuchProviderException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFileName));
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(keyFileName));
        KeyBasedLargeFileProcessor.decryptFile(in, keyIn, passwd, defaultFileName);
        ((InputStream)keyIn).close();
        ((InputStream)in).close();
    }

    private static void decryptFile(InputStream in, InputStream keyIn, char[] passwd, String defaultFileName) throws IOException, NoSuchProviderException {
        block12: {
            in = PGPUtil.getDecoderStream(in);
            try {
                String outFileName;
                PGPLiteralData ld;
                JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(in);
                Object o = pgpF.nextObject();
                PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
                Iterator it = enc.getEncryptedDataObjects();
                PGPPrivateKey sKey = null;
                PGPPublicKeyEncryptedData pbe = null;
                PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    sKey = PGPExampleUtil.findSecretKey(pgpSec, pbe.getKeyID(), passwd);
                }
                if (sKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("SAVIGNANO-BC").build(sKey));
                JcaPGPObjectFactory plainFact = new JcaPGPObjectFactory(clear);
                PGPCompressedData cData = (PGPCompressedData)plainFact.nextObject();
                BufferedInputStream compressedStream = new BufferedInputStream(cData.getDataStream());
                JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(compressedStream);
                Object message = pgpFact.nextObject();
                if (message instanceof PGPLiteralData) {
                    ld = (PGPLiteralData)message;
                    outFileName = ld.getFileName();
                    if (outFileName.length() == 0) {
                        outFileName = defaultFileName;
                    }
                } else {
                    if (message instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                InputStream unc = ld.getInputStream();
                BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(outFileName));
                Streams.pipeAll(unc, fOut);
                ((OutputStream)fOut).close();
                if (pbe.isIntegrityProtected()) {
                    if (!pbe.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block12;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(String outputFileName, String inputFileName, String encKeyFileName, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException, PGPException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFileName));
        PGPPublicKey encKey = PGPExampleUtil.readPublicKey(encKeyFileName);
        KeyBasedLargeFileProcessor.encryptFile(out, inputFileName, encKey, armor, withIntegrityCheck);
        ((OutputStream)out).close();
    }

    private static void encryptFile(OutputStream out, String fileName, PGPPublicKey encKey, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException {
        block4: {
            if (armor) {
                out = new ArmoredOutputStream(out);
            }
            try {
                PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider("SAVIGNANO-BC"));
                cPk.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider("SAVIGNANO-BC"));
                OutputStream cOut = cPk.open(out, new byte[65536]);
                PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
                PGPUtil.writeFileToLiteralData(comData.open(cOut), 'b', new File(fileName), new byte[65536]);
                comData.close();
                cOut.close();
                if (armor) {
                    out.close();
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block4;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (args.length == 0) {
            System.err.println("usage: KeyBasedLargeFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (args[0].equals("-e")) {
            if (args[1].equals("-a") || args[1].equals("-ai") || args[1].equals("-ia")) {
                KeyBasedLargeFileProcessor.encryptFile(args[2] + ".asc", args[2], args[3], true, args[1].indexOf(105) > 0);
            } else if (args[1].equals("-i")) {
                KeyBasedLargeFileProcessor.encryptFile(args[2] + ".bpg", args[2], args[3], false, true);
            } else {
                KeyBasedLargeFileProcessor.encryptFile(args[1] + ".bpg", args[1], args[2], false, false);
            }
        } else if (args[0].equals("-d")) {
            KeyBasedLargeFileProcessor.decryptFile(args[1], args[2], args[3].toCharArray(), new File(args[1]).getName() + ".out");
        } else {
            System.err.println("usage: KeyBasedLargeFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

