/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.Mailer;
import net.savignano.snotify.confluence.mailer.enums.EncryptionFailureBehaviorOption;
import net.savignano.snotify.confluence.mailer.enums.EncryptionTypePriorityOption;
import net.savignano.snotify.confluence.mailer.security.SmimeMailEncryptor;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailer
extends Mailer {
    private static final String PREFIX_PROP = "net.savignano.snotify.";
    public static final String EMAIL_SMIME_CERT_PROP = "net.savignano.snotify.email.smime.cert";
    public static final String EMAIL_SMIME_TIME_STAMP_PROP = "net.savignano.snotify.email.smime.timeStamp";
    public static final String EMAIL_SMIME_KEY_SOURCE_PROP = "net.savignano.snotify.email.smime.keySource";
    public static final String EMAIL_PGP_KEY_PROP = "net.savignano.snotify.email.pgp.key";
    public static final String EMAIL_PGP_KEY_ID_PROP = "net.savignano.snotify.email.pgp.key.id";
    public static final String EMAIL_PGP_TIME_STAMP_PROP = "net.savignano.snotify.email.pgp.timeStamp";
    public static final String EMAIL_PGP_KEY_SOURCE_PROP = "net.savignano.snotify.email.pgp.keySource";
    public static final String KEYSERVER_LOCATION_PROP = "net.savignano.snotify.pgp.keyserverLocation";
    public static final String KEYSTORE_LOCATION_PROP = "net.savignano.snotify.smime.keystoreLocation";
    public static final String KEYSTORE_PASSWORD_PROP = "net.savignano.snotify.smime.keystorePassword";
    public static final String EXPIRE_KEYS_TIMESTAMP = "net.savignano.snotify.mailer.expireKeys.timeStamp";
    public static final String ENCRYPTION_TYPE_PRIORITY_PROP = "net.savignano.snotify.mailer.encryptionTypePriority";
    public static final String ENCRYPTION_FAILURE_BEHAVIOR_PROP = "net.savignano.snotify.mailer.encryptionFailureBehavior";
    public static final String FREEZE_SNOTIFY_PROP = "net.savignano.snotify.mailer.freeze";
    public static final String DISABLE_SNOTIFY_PROP = "net.savignano.snotify.mailer.disable";
    public static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PROP = "net.savignano.snotify.pgp.key.allowUserOverwrite";
    public static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_PROP = "net.savignano.snotify.smime.cert.allowUserOverwrite";
    public static final String BOUNCY_CASTLE_KEYSTORE_TYPE = "BKS";
    public static final String TWEAK_ENCODE_PGP_SEARCH_PARAMETER_PROP = "net.savignano.snotify.tweak.encodePgpSearchParam";
    public static final String TWEAK_URL_CONNECTION_TIMEOUT = "net.savignano.snotify.tweak.urlConnectionTimeoutDuringMailing";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailer.class);
    private KeyStore keyStore;

    private static KeyStore loadKeyStore(String location, String password, Provider provider) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (location == null || location.isEmpty()) {
            log.debug("No location given. No S/MIME keystore loaded.");
            return null;
        }
        if (provider == null || location.isEmpty()) {
            log.debug("No provider given. No S/MIME keystore loaded.");
            return null;
        }
        KeyStore ks = KeyStore.getInstance(BOUNCY_CASTLE_KEYSTORE_TYPE, provider);
        log.debug("Loading keystore from location: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            ks.load(in, password == null ? null : password.toCharArray());
        }
        log.debug("Loaded keystore from location \"{}\" succesfully.", (Object)location);
        return ks;
    }

    @Override
    protected SmimeMailEncryptor getSmimeEncryptor(Session session, MimeMessage orgMsg, Address address) {
        SmimeMailEncryptor smimeEncryptor = super.getSmimeEncryptor(session, orgMsg, address);
        smimeEncryptor.setKeyStore(this.getKeyStore());
        return smimeEncryptor;
    }

    public KeyStore getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = this.loadKeyStore();
        }
        return this.keyStore;
    }

    protected KeyStore loadKeyStore() {
        String location = PropertiesUtil.getAppProps().getString(KEYSTORE_LOCATION_PROP);
        String password = PropertiesUtil.getAppProps().getString(KEYSTORE_PASSWORD_PROP);
        try {
            return ConfluenceMailer.loadKeyStore(location, password, this.getProvider());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Could not load keystore from location: " + location, (Throwable)e);
            return null;
        }
    }

    @Override
    protected EncryptionTypePriorityOption loadTypePriority() {
        EncryptionTypePriorityOption encryptionTypePriority = PropertiesUtil.getAppProps().getEnum(ENCRYPTION_TYPE_PRIORITY_PROP, EncryptionTypePriorityOption.class);
        if (encryptionTypePriority == null) {
            encryptionTypePriority = super.loadTypePriority();
        }
        return encryptionTypePriority;
    }

    @Override
    protected EncryptionFailureBehaviorOption loadFailureBehavior() {
        EncryptionFailureBehaviorOption encryptionFailure = PropertiesUtil.getAppProps().getEnum(ENCRYPTION_FAILURE_BEHAVIOR_PROP, EncryptionFailureBehaviorOption.class);
        if (encryptionFailure == null) {
            encryptionFailure = super.loadFailureBehavior();
        }
        return encryptionFailure;
    }

    @Override
    protected boolean loadDisabled() {
        return PropertiesUtil.getAppProps().getBoolean(DISABLE_SNOTIFY_PROP);
    }

    @Override
    protected boolean loadFrozen() {
        return PropertiesUtil.getAppProps().getBoolean(FREEZE_SNOTIFY_PROP);
    }
}

