/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.MessageAndAddress;
import net.savignano.snotify.confluence.mailer.enums.EncryptionFailureBehaviorOption;
import net.savignano.snotify.confluence.mailer.enums.EncryptionTypePriorityOption;
import net.savignano.snotify.confluence.mailer.security.PgpMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.SmimeMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.key.EKeyValidity;
import net.savignano.snotify.confluence.mailer.security.key.SnotifyPgpKey;
import net.savignano.snotify.confluence.mailer.security.key.SnotifySmimeKey;
import net.savignano.snotify.confluence.mailer.util.MessageUtil;
import net.savignano.snotify.confluence.mailer.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String XENCRPYTED_MAIL_PROPERTY = "X-Encrypted";
    private static final Logger log = LoggerFactory.getLogger(Mailer.class);
    private Provider provider;
    private String hostName;
    private EncryptionTypePriorityOption typePriority;
    private EncryptionFailureBehaviorOption failureBehavior;
    private Boolean disabled;
    private Boolean frozen;

    public MessageAndAddress[] getMessages(Session session, Message message, Address[] addresses) {
        if (this.isDisabled()) {
            log.info("S/Notify is disabled. Emails will not be encrypted.");
            MessageAndAddress[] result = new MessageAndAddress[addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MessageAndAddress(message, addresses[i]);
            }
            return result;
        }
        boolean licenseErrorReported = false;
        ArrayList<MessageAndAddress> result = new ArrayList<MessageAndAddress>();
        for (Address address : addresses) {
            EKeyValidity validity;
            MessageAndAddress messageAndAddress = new MessageAndAddress();
            messageAndAddress.address = address;
            messageAndAddress.message = message;
            if (this.isFrozen()) {
                if (!licenseErrorReported) {
                    log.error("Could not encrypt email due to licensing error in S/Notify. Handling unencrypted email as: " + (Object)((Object)this.getFailureBehavior()));
                    licenseErrorReported = true;
                }
                validity = EKeyValidity.ERROR;
            } else if (message instanceof MimeMessage) {
                try {
                    log.debug("Starting email encryption to address: {}", (Object)address);
                    EncryptionData data = this.getEncryptedMessage(session, (MimeMessage)message, address);
                    validity = data.validity;
                    log.debug("Validity of encryption: {}", (Object)validity);
                    if (validity == EKeyValidity.VALID) {
                        messageAndAddress.message = data.message;
                    } else if (this.getFailureBehavior() != EncryptionFailureBehaviorOption.ALLOW) {
                        log.warn("Could not encrypt email for: {}", (Object)address);
                    }
                }
                catch (Exception e) {
                    log.error("Error encrypting email for address " + address + ": " + e.getMessage(), (Throwable)e);
                    validity = EKeyValidity.ERROR;
                }
            } else {
                log.error("Can't encrypt email, because it is not a MIME Email but: " + message.getClass().getCanonicalName());
                validity = EKeyValidity.ERROR;
            }
            if (validity == EKeyValidity.VALID || this.getFailureBehavior() == EncryptionFailureBehaviorOption.ALLOW) {
                result.add(messageAndAddress);
                continue;
            }
            if (this.getFailureBehavior() != EncryptionFailureBehaviorOption.REPORT) continue;
            try {
                messageAndAddress.message = validity == EKeyValidity.ERROR ? MessageUtil.createInternalErrorInfoMail(message, session) : MessageUtil.createMissingKeyInfoMail(message, session);
                result.add(messageAndAddress);
            }
            catch (MessagingException e) {
                log.error("Error creating info email for email address " + address + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return result.toArray(new MessageAndAddress[result.size()]);
    }

    protected EncryptionData getEncryptedMessage(Session session, MimeMessage orgMsg, Address address) throws Exception {
        EncryptionData data = null;
        log.debug("Using type priority for encryption: {}", (Object)this.getTypePriority());
        switch (this.getTypePriority()) {
            case PGP_ONLY: {
                data = this.getEncryptedPgpMessage(session, orgMsg, address);
                break;
            }
            case PGP_PREFERED: {
                data = this.getEncryptedPgpMessage(session, orgMsg, address);
                if (data.validity == EKeyValidity.VALID) break;
                EncryptionData alternateData = this.getEncryptedSmimeMessage(session, orgMsg, address);
                if (alternateData.validity != EKeyValidity.VALID) break;
                data = alternateData;
                break;
            }
            case SMIME_ONLY: {
                data = this.getEncryptedSmimeMessage(session, orgMsg, address);
                break;
            }
            case SMIME_PREFERED: {
                data = this.getEncryptedSmimeMessage(session, orgMsg, address);
                if (data.validity == EKeyValidity.VALID) break;
                EncryptionData alternateData = this.getEncryptedPgpMessage(session, orgMsg, address);
                if (alternateData.validity != EKeyValidity.VALID) break;
                data = alternateData;
                break;
            }
            default: {
                throw new IllegalStateException("The given type priority (" + (Object)((Object)this.getTypePriority()) + ") is not yet implemented.");
            }
        }
        return data;
    }

    private EncryptionData getEncryptedSmimeMessage(Session session, MimeMessage orgMsg, Address address) throws MessagingException, IOException {
        EncryptionData data = new EncryptionData();
        SmimeMailEncryptor encryption = this.getSmimeEncryptor(session, orgMsg, address);
        data.validity = ((SnotifySmimeKey)encryption.getPublicKey()).getKeyValidity();
        if (data.validity == EKeyValidity.VALID) {
            data.message = encryption.getEncryptedMessage();
        }
        return data;
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Session session, MimeMessage orgMsg, Address address) {
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(session, orgMsg, address);
        encryptor.setHostName(this.getHostName());
        return encryptor;
    }

    private EncryptionData getEncryptedPgpMessage(Session session, MimeMessage orgMsg, Address address) throws IOException, MessagingException {
        EncryptionData data = new EncryptionData();
        PgpMailEncryptor encryption = this.getPgpEncryptor(session, orgMsg, address);
        data.validity = ((SnotifyPgpKey)encryption.getPublicKey()).getKeyValidity();
        if (data.validity == EKeyValidity.VALID) {
            data.message = encryption.getEncryptedMessage();
        }
        return data;
    }

    protected PgpMailEncryptor getPgpEncryptor(Session session, MimeMessage orgMsg, Address address) {
        PgpMailEncryptor encryptor = new PgpMailEncryptor(session, orgMsg, address);
        encryptor.setHostName(this.getHostName());
        return encryptor;
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            this.disabled = this.loadDisabled();
        }
        return this.disabled;
    }

    protected boolean loadDisabled() {
        return false;
    }

    public boolean isFrozen() {
        if (this.frozen == null) {
            this.frozen = this.loadFrozen();
        }
        return this.frozen;
    }

    protected boolean loadFrozen() {
        return false;
    }

    public EncryptionTypePriorityOption getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.loadTypePriority();
        }
        return this.typePriority;
    }

    protected EncryptionTypePriorityOption loadTypePriority() {
        return EncryptionTypePriorityOption.SMIME_PREFERED;
    }

    public EncryptionFailureBehaviorOption getFailureBehavior() {
        if (this.failureBehavior == null) {
            this.failureBehavior = this.loadFailureBehavior();
        }
        return this.failureBehavior;
    }

    protected EncryptionFailureBehaviorOption loadFailureBehavior() {
        return EncryptionFailureBehaviorOption.ALLOW;
    }

    public Provider getProvider() {
        if (this.provider == null) {
            this.provider = this.loadProvider();
        }
        return this.provider;
    }

    protected Provider loadProvider() {
        return SecurityUtil.getProvider();
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.loadHostName();
        }
        return this.hostName;
    }

    protected String loadHostName() {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (UnknownHostException e) {
            log.debug("Could not retrieve host name.", (Throwable)e);
        }
        try {
            String host = System.getenv("COMPUTERNAME");
            if (host != null) {
                return host;
            }
            host = System.getenv("HOSTNAME");
            if (host != null) {
                return host;
            }
        }
        catch (SecurityException e) {
            log.debug("Could not retrieve host name from environment properties.", (Throwable)e);
        }
        return "<Unknown>";
    }

    private static final class EncryptionData {
        public MimeMessage message;
        public EKeyValidity validity;

        private EncryptionData() {
        }
    }
}

