/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.enums.EncryptionKeySource;
import net.savignano.snotify.confluence.mailer.security.key.EKeyValidity;
import net.savignano.snotify.confluence.mailer.security.key.ISnotifyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailEncryptor<T extends ISnotifyKey<?>> {
    private static final long EXPIRE_DURATION = 43200000L;
    private static final Logger log = LoggerFactory.getLogger(AbstractMailEncryptor.class);
    private final Session session;
    private final Address address;
    private final MimeMessage message;
    private User user;
    private String hostName;
    private T publicKey;

    private static final User getUserForAddress(Address address) {
        String email = address.toString();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        SearchResult searchResult = userAccessor.getUsersByEmail(email);
        Iterator users = searchResult.pager().iterator();
        if (users.hasNext()) {
            User user = (User)users.next();
            log.debug("Found user {} for email \"{}\".", (Object)user, (Object)email);
            if (users.hasNext()) {
                ArrayList<Object> logUsers = new ArrayList<Object>();
                logUsers.add(user);
                while (users.hasNext()) {
                    logUsers.add(users.next());
                }
                log.warn("Multiple users found for email \"{}\". First user found used for encryption purposes, but this can be unpredictable: {}", (Object)email, logUsers);
            }
            return user;
        }
        log.error("No user found for email: {}", (Object)email);
        return null;
    }

    public AbstractMailEncryptor(Session session, MimeMessage message, Address address) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message must not be null.");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address must not be null.");
        }
        this.session = session;
        this.message = message;
        this.address = address;
        this.setHostName("<Unknown>");
    }

    public MimeMessage getEncryptedMessage() throws IOException, MessagingException {
        if (this.getPublicKey().getKeyValidity() != EKeyValidity.VALID) {
            throw new MessagingException("Can not encrypt message to address " + this.address + " because of key having validity: " + (Object)((Object)this.getPublicKey().getKeyValidity()));
        }
        return this.encrypt();
    }

    protected abstract MimeMessage encrypt() throws IOException, MessagingException;

    protected T loadPublicKey() {
        boolean isGetRepositoryKey;
        if (this.getUser() == null) {
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        EncryptorPropertiesData data = this.getPropertiesData();
        log.debug("Used properties for determining validity of key: {}", (Object)data);
        if (log.isTraceEnabled()) {
            log.trace("Used properties for determining validity of key (verbose): {}", (Object)data.toString(false));
        }
        T publicKey = this.getUserPublicKey();
        switch (publicKey.getKeyValidity()) {
            case VALID: {
                isGetRepositoryKey = data.keySource == EncryptionKeySource.USER ? !data.allowCustomUserKey : data.expireTimeStamp != null && (data.timeStamp == null || data.expireTimeStamp > data.timeStamp);
                log.debug("Does valid key from source {} need to be loaded from repository: {}", (Object)data.keySource, (Object)isGetRepositoryKey);
                break;
            }
            case INVALID: 
            case NOT_FOUND: {
                isGetRepositoryKey = data.timeStamp == null || System.currentTimeMillis() > data.timeStamp + 43200000L || data.expireTimeStamp != null && data.expireTimeStamp > data.timeStamp;
                log.debug("Key can't be used. Need to be loaded from repository: {}", (Object)isGetRepositoryKey);
                break;
            }
            case ERROR: {
                isGetRepositoryKey = true;
                break;
            }
            default: {
                log.error("Unknown validity enum value: {}", (Object)publicKey.getKeyValidity());
                isGetRepositoryKey = true;
            }
        }
        if (isGetRepositoryKey && (publicKey = this.getRepositoryPublicKey()).getKeyValidity() != EKeyValidity.ERROR) {
            try {
                this.storePublicKey(publicKey);
            }
            catch (IOException e) {
                log.error("Public key could not be stored for user " + this.getUser() + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return publicKey;
    }

    protected abstract T getValidityKey(EKeyValidity var1);

    protected abstract T getRepositoryPublicKey();

    protected abstract T getUserPublicKey();

    protected abstract void storePublicKey(T var1) throws IOException;

    protected abstract EncryptorPropertiesData getPropertiesData();

    public T getPublicKey() {
        if (this.publicKey == null) {
            this.setPublicKey(this.loadPublicKey());
        }
        return this.publicKey;
    }

    public void setPublicKey(T publicKey) {
        this.publicKey = publicKey;
    }

    public Session getSession() {
        return this.session;
    }

    public Address getAddress() {
        return this.address;
    }

    public User getUser() {
        if (this.user == null) {
            this.user = this.loadUser();
        }
        return this.user;
    }

    protected User loadUser() {
        return AbstractMailEncryptor.getUserForAddress(this.getAddress());
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public static class EncryptorPropertiesData {
        public Long expireTimeStamp;
        public Long timeStamp;
        public EncryptionKeySource keySource;
        public boolean allowCustomUserKey;

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean userFriendlyDates) {
            if (userFriendlyDates) {
                return "EncryptorPropertiesData [expireRepositoryData=" + (this.expireTimeStamp == null ? null : new Date(this.expireTimeStamp)) + ", timeStamp=" + (this.timeStamp == null ? null : new Date(this.timeStamp)) + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", currentTime=" + new Date(System.currentTimeMillis()) + "]";
            }
            return "EncryptorPropertiesData [expireRepositoryData=" + this.expireTimeStamp + ", timeStamp=" + this.timeStamp + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", currentTime=" + System.currentTimeMillis() + "]";
        }
    }
}

