/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security.key;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.confluence.mailer.security.key.ASnotifyKey;
import net.savignano.snotify.confluence.mailer.security.key.EKeyValidity;
import net.savignano.snotify.confluence.mailer.util.CertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmimeKey
extends ASnotifyKey<X509Certificate> {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmimeKey.class);
    private final X509Certificate certificate;

    public SnotifySmimeKey(X509Certificate certificate) {
        this(certificate, null);
    }

    public SnotifySmimeKey(X509Certificate certificate, String email) {
        this.certificate = certificate;
        try {
            if (email == null || CertUtil.isCertForEmail(certificate, email)) {
                certificate.checkValidity();
            } else {
                this.setKeyValidity(EKeyValidity.INVALID);
            }
        }
        catch (CertificateExpiredException e) {
            log.debug("Certificate with serial number {} is invalid because it expired at: ", (Object)certificate.getSerialNumber(), (Object)certificate.getNotAfter());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateNotYetValidException e) {
            log.debug("Certificate with serial number {} could : ", (Object)certificate.getSerialNumber(), (Object)certificate.getNotBefore());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateException e) {
            log.error("Could not check that email " + email + " matches certificate with serial number " + certificate.getSerialNumber() + ".", (Throwable)e);
            this.setKeyValidity(EKeyValidity.ERROR);
        }
    }

    public SnotifySmimeKey(EKeyValidity validity) {
        this.certificate = null;
        this.setKeyValidity(validity);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        if (this.certificate == null) {
            return null;
        }
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate getEncryptionKey() {
        return this.certificate;
    }
}

