/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.util;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.RDN;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    public static final String X509_FACTORY_KEY = "X.509";
    private static final Logger log = LoggerFactory.getLogger(CertUtil.class);

    public static X509Certificate createCertificate(byte[] content) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        CertificateFactory fact = CertificateFactory.getInstance(X509_FACTORY_KEY);
        return (X509Certificate)fact.generateCertificate(is);
    }

    public static final X509Certificate getValidCertForEmail(KeyStore keyStore, String email) {
        Enumeration<String> aliases;
        if (keyStore == null || email == null) {
            return null;
        }
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            log.error("Error getting aliases from KeyStore: " + keyStore, (Throwable)e);
            return null;
        }
        X509Certificate chosenCertificate = null;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certificate = null;
            try {
                certificate = CertUtil.getCertForAlias(keyStore, alias);
            }
            catch (KeyStoreException e) {
                log.error("Error getting certificate for alias: " + alias, (Throwable)e);
                continue;
            }
            boolean certForEmail = false;
            try {
                certForEmail = CertUtil.isCertForEmail(certificate, email);
            }
            catch (CertificateEncodingException e) {
                log.error("Error extracting the information from certificate: " + certificate, (Throwable)e);
                continue;
            }
            catch (CertificateParsingException e) {
                log.error("Subject Alternative Names Extension could not be parsed from certificate: " + certificate, (Throwable)e);
                continue;
            }
            if (!certForEmail) continue;
            try {
                certificate.checkValidity();
                log.debug("Found valid certificate for email \"{}\": {}", (Object)email, (Object)certificate);
                if (chosenCertificate != null) {
                    if (!certificate.getNotAfter().after(chosenCertificate.getNotAfter())) continue;
                    chosenCertificate = certificate;
                    continue;
                }
                chosenCertificate = certificate;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                log.debug("Found invalid certificate for email \"{}\": {}", (Object)email, (Object)certificate);
            }
        }
        log.debug("Found certificate for email \"{}\": {}", (Object)email, chosenCertificate);
        return chosenCertificate;
    }

    public static final X509Certificate getCertForEmail(KeyStore keyStore, String email) throws KeyStoreException, CertificateException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certificate = CertUtil.getCertForAlias(keyStore, alias);
            if (!CertUtil.isCertForEmail(certificate, email)) continue;
            return certificate;
        }
        return null;
    }

    private static final X509Certificate getCertForAlias(KeyStore keyStore, String alias) throws KeyStoreException {
        Certificate cert = keyStore.getCertificate(alias);
        if (!(cert instanceof X509Certificate)) {
            log.warn("Certificate found for alias \"{}\" is not a X509Certificate. It will be skipped. Found certificate: {}", (Object)alias, (Object)cert);
            return null;
        }
        return (X509Certificate)cert;
    }

    public static final boolean isCertForEmail(X509Certificate certificate, String email) throws CertificateEncodingException, CertificateParsingException {
        if (certificate == null || email == null) {
            return false;
        }
        X500Name subject = CertUtil.getSubject(certificate);
        boolean emailMatches = false;
        String foundEmail = CertUtil.getRDNValue(subject, BCStyle.E);
        if (email.equalsIgnoreCase(foundEmail)) {
            emailMatches = true;
        } else {
            Collection<List<?>> names = certificate.getSubjectAlternativeNames();
            if (names != null) {
                for (List<?> item : names) {
                    int type = (Integer)item.get(0);
                    Object value = item.get(1);
                    if (type != 1 || !email.equalsIgnoreCase(value.toString())) continue;
                    emailMatches = true;
                    break;
                }
            }
        }
        return emailMatches;
    }

    public static final X500Name getIssuer(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getIssuer();
    }

    public static final X500Name getSubject(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getSubject();
    }

    public static final String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }
}

