/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import net.savignano.thirdparty.org.bouncycastle.crypto.ExtendedDigest;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] blake2s_IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] blake2s_sigma = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};
    private static final int ROUNDS = 10;
    private static final int BLOCK_LENGTH_BYTES = 64;
    private int digestLength = 32;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private int[] internalState = new int[16];
    private int[] chainValue = null;
    private int t0 = 0;
    private int t1 = 0;
    private int f0 = 0;

    public Blake2sDigest() {
        this(256);
    }

    public Blake2sDigest(Blake2sDigest digest) {
        this.bufferPos = digest.bufferPos;
        this.buffer = Arrays.clone(digest.buffer);
        this.keyLength = digest.keyLength;
        this.key = Arrays.clone(digest.key);
        this.digestLength = digest.digestLength;
        this.chainValue = Arrays.clone(digest.chainValue);
        this.personalization = Arrays.clone(digest.personalization);
    }

    public Blake2sDigest(int digestBits) {
        if (digestBits != 128 && digestBits != 160 && digestBits != 224 && digestBits != 256) {
            throw new IllegalArgumentException("BLAKE2s digest restricted to one of [128, 160, 224, 256]");
        }
        this.buffer = new byte[64];
        this.keyLength = 0;
        this.digestLength = digestBits / 8;
        this.init();
    }

    public Blake2sDigest(byte[] key) {
        this.buffer = new byte[64];
        if (key != null) {
            if (key.length > 32) {
                throw new IllegalArgumentException("Keys > 32 are not supported");
            }
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 64;
        }
        this.digestLength = 32;
        this.init();
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization) {
        this.buffer = new byte[64];
        if (digestBytes < 1 || digestBytes > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.digestLength = digestBytes;
        if (salt != null) {
            if (salt.length != 8) {
                throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
            }
            this.salt = new byte[8];
            System.arraycopy(salt, 0, this.salt, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 8) {
                throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
            }
            this.personalization = new byte[8];
            System.arraycopy(personalization, 0, this.personalization, 0, personalization.length);
        }
        if (key != null) {
            if (key.length > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 64;
        }
        this.init();
    }

    private void init() {
        if (this.chainValue == null) {
            this.chainValue = new int[8];
            this.chainValue[0] = blake2s_IV[0] ^ (this.digestLength | this.keyLength << 8 | 0x1010000);
            this.chainValue[1] = blake2s_IV[1];
            this.chainValue[2] = blake2s_IV[2];
            this.chainValue[3] = blake2s_IV[3];
            this.chainValue[4] = blake2s_IV[4];
            this.chainValue[5] = blake2s_IV[5];
            if (this.salt != null) {
                this.chainValue[4] = this.chainValue[4] ^ this.bytes2int(this.salt, 0);
                this.chainValue[5] = this.chainValue[5] ^ this.bytes2int(this.salt, 4);
            }
            this.chainValue[6] = blake2s_IV[6];
            this.chainValue[7] = blake2s_IV[7];
            if (this.personalization != null) {
                this.chainValue[6] = this.chainValue[6] ^ this.bytes2int(this.personalization, 0);
                this.chainValue[7] = this.chainValue[7] ^ this.bytes2int(this.personalization, 4);
            }
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(blake2s_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ blake2s_IV[4];
        this.internalState[13] = this.t1 ^ blake2s_IV[5];
        this.internalState[14] = this.f0 ^ blake2s_IV[6];
        this.internalState[15] = blake2s_IV[7];
    }

    public void update(byte b) {
        int remainingLength = 64 - this.bufferPos;
        if (remainingLength == 0) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, (byte)0);
            this.buffer[0] = b;
            this.bufferPos = 1;
        } else {
            this.buffer[this.bufferPos] = b;
            ++this.bufferPos;
        }
    }

    public void update(byte[] message, int offset, int len) {
        int messagePos;
        if (message == null || len == 0) {
            return;
        }
        int remainingLength = 0;
        if (this.bufferPos != 0) {
            remainingLength = 64 - this.bufferPos;
            if (remainingLength < len) {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, remainingLength);
                this.t0 += 64;
                if (this.t0 == 0) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, len);
                this.bufferPos += len;
                return;
            }
        }
        int blockWiseLastPos = offset + len - 64;
        for (messagePos = offset + remainingLength; messagePos < blockWiseLastPos; messagePos += 64) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(message, messagePos);
        }
        System.arraycopy(message, messagePos, this.buffer, 0, offset + len - messagePos);
        this.bufferPos += offset + len - messagePos;
    }

    public int doFinal(byte[] out, int outOffset) {
        this.f0 = -1;
        this.t0 += this.bufferPos;
        if (this.t0 < 0 && this.bufferPos > -this.t0) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0);
        for (int i = 0; i < this.chainValue.length && i * 4 < this.digestLength; ++i) {
            byte[] bytes = this.int2bytes(this.chainValue[i]);
            if (i * 4 < this.digestLength - 4) {
                System.arraycopy(bytes, 0, out, outOffset + i * 4, 4);
                continue;
            }
            System.arraycopy(bytes, 0, out, outOffset + i * 4, this.digestLength - i * 4);
        }
        Arrays.fill(this.chainValue, 0);
        this.reset();
        return this.digestLength;
    }

    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0;
        this.t0 = 0;
        this.t1 = 0;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 64;
        }
        this.init();
    }

    private void compress(byte[] message, int messagePos) {
        this.initializeInternalState();
        int[] m = new int[16];
        for (int j = 0; j < 16; ++j) {
            m[j] = this.bytes2int(message, messagePos + j * 4);
        }
        for (int round = 0; round < 10; ++round) {
            this.G(m[blake2s_sigma[round][0]], m[blake2s_sigma[round][1]], 0, 4, 8, 12);
            this.G(m[blake2s_sigma[round][2]], m[blake2s_sigma[round][3]], 1, 5, 9, 13);
            this.G(m[blake2s_sigma[round][4]], m[blake2s_sigma[round][5]], 2, 6, 10, 14);
            this.G(m[blake2s_sigma[round][6]], m[blake2s_sigma[round][7]], 3, 7, 11, 15);
            this.G(m[blake2s_sigma[round][8]], m[blake2s_sigma[round][9]], 0, 5, 10, 15);
            this.G(m[blake2s_sigma[round][10]], m[blake2s_sigma[round][11]], 1, 6, 11, 12);
            this.G(m[blake2s_sigma[round][12]], m[blake2s_sigma[round][13]], 2, 7, 8, 13);
            this.G(m[blake2s_sigma[round][14]], m[blake2s_sigma[round][15]], 3, 4, 9, 14);
        }
        for (int offset = 0; offset < this.chainValue.length; ++offset) {
            this.chainValue[offset] = this.chainValue[offset] ^ this.internalState[offset] ^ this.internalState[offset + 8];
        }
    }

    private void G(int m1, int m2, int posA, int posB, int posC, int posD) {
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m1;
        this.internalState[posD] = this.rotr32(this.internalState[posD] ^ this.internalState[posA], 16);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = this.rotr32(this.internalState[posB] ^ this.internalState[posC], 12);
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m2;
        this.internalState[posD] = this.rotr32(this.internalState[posD] ^ this.internalState[posA], 8);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = this.rotr32(this.internalState[posB] ^ this.internalState[posC], 7);
    }

    private int rotr32(int x, int rot) {
        return x >>> rot | x << 32 - rot;
    }

    private byte[] int2bytes(int intValue) {
        return new byte[]{(byte)intValue, (byte)(intValue >> 8), (byte)(intValue >> 16), (byte)(intValue >> 24)};
    }

    private int bytes2int(byte[] byteArray, int offset) {
        return byteArray[offset] & 0xFF | (byteArray[offset + 1] & 0xFF) << 8 | (byteArray[offset + 2] & 0xFF) << 16 | (byteArray[offset + 3] & 0xFF) << 24;
    }

    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    public int getDigestSize() {
        return this.digestLength;
    }

    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.salt != null) {
            Arrays.fill(this.salt, (byte)0);
        }
    }
}

