/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.SnotifyMimeMessage;
import net.savignano.snotify.confluence.mailer.enums.EncryptionKeySource;
import net.savignano.snotify.confluence.mailer.security.AbstractMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.key.EKeyValidity;
import net.savignano.snotify.confluence.mailer.security.key.SnotifySmimeKey;
import net.savignano.snotify.confluence.mailer.util.CertUtil;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailEncryptor
extends AbstractMailEncryptor<SnotifySmimeKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify for Confluence at {0} using S/MIME encryption with {1}";
    private KeyStore keyStore;

    public SmimeMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected SnotifySmimeKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimeKey(validity);
    }

    @Override
    protected SnotifySmimeKey getRepositoryPublicKey() {
        if (this.getKeyStore() == null) {
            log.debug("No key store specified. Can't get certificate from key store.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        String email = this.getAddress().toString();
        X509Certificate certificate = CertUtil.getValidCertForEmail(this.getKeyStore(), email);
        if (certificate != null) {
            return new SnotifySmimeKey(certificate, email);
        }
        try {
            certificate = CertUtil.getCertForEmail(this.getKeyStore(), email);
        }
        catch (KeyStoreException | CertificateException e) {
            log.error("Could not load certificate from key store for email " + email + ".", (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        return certificate == null ? this.getValidityKey(EKeyValidity.NOT_FOUND) : new SnotifySmimeKey(certificate);
    }

    @Override
    protected SnotifySmimeKey getUserPublicKey() {
        byte[] cert = PropertiesUtil.getUserProps().getBytes("net.savignano.snotify.email.smime.cert", this.getUser());
        if (cert != null) {
            log.debug("Using certificate of user {} for encrypting email to \"{}\".", (Object)this.getUser(), (Object)this.getAddress());
            try {
                X509Certificate certificate = CertUtil.createCertificate(cert);
                return new SnotifySmimeKey(certificate);
            }
            catch (CertificateException e) {
                log.error("Could not parse certificate stored for user: " + this.getUser(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no public certificate stored.", (Object)this.getUser());
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    protected void storePublicKey(SnotifySmimeKey key) throws IOException {
        log.debug("Storing new S/MIME certificate to user properties: {}", (Object)key.getEncryptionKey());
        PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.smime.cert", key.getEncoded(), this.getUser());
        PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.smime.timeStamp", System.currentTimeMillis(), this.getUser());
        PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.KEYSTORE, this.getUser());
    }

    @Override
    protected MimeMessage encrypt() throws IOException, MessagingException {
        MimeBodyPart encryptedBody;
        String usedEncryptionAlgorithm;
        log.debug("Encrypting email to \"{}\" with certificate: {}", (Object)this.getAddress(), (Object)((SnotifySmimeKey)this.getPublicKey()).getEncryptionKey());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMessage().writeTo((OutputStream)baos);
            log.trace("Original email:\n{}\n", (Object)baos.toString());
        }
        SnotifyMimeMessage copyMsg = new SnotifyMimeMessage(this.getMessage());
        copyMsg.getContent();
        SnotifyMimeMessage msg = new SnotifyMimeMessage(this.getSession());
        Enumeration copyHeaders = copyMsg.getAllHeaderLines();
        while (copyHeaders.hasMoreElements()) {
            msg.addHeaderLine((String)copyHeaders.nextElement());
        }
        try {
            OutputEncryptor encryptor;
            SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
            BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(((SnotifySmimeKey)this.getPublicKey()).getEncryptionKey()));
            gen.addRecipientInfoGenerator(infoGenerator);
            try {
                log.debug("Using AES256_CBC algorithm for encryption.");
                usedEncryptionAlgorithm = "AES256_CBC";
                encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build();
            }
            catch (CMSException e) {
                if (e.getMessage().contains("Illegal key size")) {
                    log.debug(e.getMessage(), (Throwable)e);
                    log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. AES256_CBC encryption standard can not be used. Using fallback AES128_CBC encryption algorithm.");
                    usedEncryptionAlgorithm = "AES128_CBC";
                    encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build();
                }
                throw e;
            }
            encryptedBody = gen.generate(copyMsg, encryptor);
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                encryptedBody.writeTo((OutputStream)baos);
                log.trace("Encrypted body:\n{}\n", (Object)baos.toString());
            }
        }
        catch (CertificateEncodingException | CMSException | SMIMEException e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        msg.setContent(encryptedBody.getContent(), encryptedBody.getContentType());
        msg.addHeader("X-Encrypted", MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), usedEncryptionAlgorithm));
        msg.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo(baos);
            log.trace("Final email:\n{}\n", (Object)baos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)this.getAddress());
        return msg;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    protected AbstractMailEncryptor.EncryptorPropertiesData getPropertiesData() {
        AbstractMailEncryptor.EncryptorPropertiesData data = new AbstractMailEncryptor.EncryptorPropertiesData();
        data.allowCustomUserKey = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        data.expireTimeStamp = PropertiesUtil.getAppProps().getLong("net.savignano.snotify.mailer.expireKeys.timeStamp");
        data.keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.class, this.getUser());
        data.timeStamp = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.smime.timeStamp", this.getUser());
        return data;
    }
}

