/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.snotify.confluence.mailer.SnotifyMimeMessage;
import net.savignano.snotify.confluence.mailer.enums.EncryptionKeySource;
import net.savignano.snotify.confluence.mailer.security.AbstractMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.PgpPublicKeyLoader;
import net.savignano.snotify.confluence.mailer.security.key.EKeyValidity;
import net.savignano.snotify.confluence.mailer.security.key.SnotifyPgpKey;
import net.savignano.snotify.confluence.mailer.util.PgpUtil;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailEncryptor
extends AbstractMailEncryptor<SnotifyPgpKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify for Confluence at {0} using PGP encryption with 3DES";

    public PgpMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected SnotifyPgpKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpKey(validity);
    }

    @Override
    protected SnotifyPgpKey getRepositoryPublicKey() {
        String keyServer = PropertiesUtil.getAppProps().getString("net.savignano.snotify.pgp.keyserverLocation");
        if (keyServer == null) {
            log.debug("No key server configured to retrieve PGP public keys from.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        boolean encodeSearchParam = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.tweak.encodePgpSearchParam", true);
        Long timeout = PropertiesUtil.getAppProps().getLong("net.savignano.snotify.tweak.urlConnectionTimeoutDuringMailing");
        PgpPublicKeyLoader loader = new PgpPublicKeyLoader(keyServer, this.getAddress().toString());
        loader.setEncodeSearchParam(encodeSearchParam);
        if (timeout != null && timeout.intValue() >= 0) {
            loader.setTimeout(timeout.intValue());
        }
        return loader.loadKey();
    }

    @Override
    protected SnotifyPgpKey getUserPublicKey() {
        Long keyId = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.pgp.key.id", this.getUser());
        byte[] key = PropertiesUtil.getUserProps().getBytes("net.savignano.snotify.email.pgp.key", this.getUser());
        if (keyId != null && key != null) {
            log.debug("Using public key of user {} for encrypting email to \"{}\".", (Object)this.getUser(), (Object)this.getAddress());
            try {
                return new SnotifyPgpKey(PgpUtil.getPublicCollection(key), this.getAddress().toString());
            }
            catch (IOException | PGPException e) {
                log.error("Could not load public key of user " + this.getUser() + " because an exception occured.", (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no public key stored.", (Object)this.getUser());
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    protected void storePublicKey(SnotifyPgpKey key) throws IOException {
        log.debug("Storing new PGP key to user properties: {}", (Object)key.getMasterKey());
        PGPPublicKey encryptionKey = key.getEncryptionKey();
        PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.pgp.key", key.getEncoded(), this.getUser());
        PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.key.id", encryptionKey == null ? null : Long.valueOf(encryptionKey.getKeyID()), this.getUser());
        PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.timeStamp", System.currentTimeMillis(), this.getUser());
        PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.KEYSERVER, this.getUser());
    }

    @Override
    protected MimeMessage encrypt() throws IOException, MessagingException {
        String encryptedMessage;
        PGPPublicKey encryptionKey = ((SnotifyPgpKey)this.getPublicKey()).getEncryptionKey();
        log.debug("Encrypting email to \"{}\" with public key: {}", (Object)this.getAddress(), (Object)Long.toHexString(encryptionKey.getKeyID()).toUpperCase());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            this.getMessage().writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        SnotifyMimeMessage sMsg = new SnotifyMimeMessage(this.getMessage());
        try {
            encryptedMessage = new String(PgpUtil.encrypt(sMsg, encryptionKey), StandardCharsets.US_ASCII);
            log.trace("Encrypted message: {}", (Object)encryptedMessage);
        }
        catch (PGPException e) {
            throw new MessagingException(e.getLocalizedMessage(), (Exception)e);
        }
        MimeBodyPart partVersion = new MimeBodyPart();
        partVersion.setContent((Object)"Version: 1\n", "application/pgp-encrypted");
        MimeBodyPart partEncrypted = new MimeBodyPart();
        partEncrypted.setContent((Object)encryptedMessage, "application/octet-stream");
        partEncrypted.setDisposition("inline");
        MimeMultipart multipart = new MimeMultipart("encrypted"){

            public synchronized String getContentType() {
                return super.getContentType() + ";\n\tprotocol=\"application/pgp-encrypted\"";
            }
        };
        multipart.addBodyPart((BodyPart)partVersion);
        multipart.addBodyPart((BodyPart)partEncrypted);
        SnotifyMimeMessage message = new SnotifyMimeMessage(this.getSession());
        Enumeration iter = this.getMessage().getAllHeaderLines();
        while (iter.hasMoreElements()) {
            message.addHeaderLine((String)iter.nextElement());
        }
        message.addHeader("X-Encrypted", MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName()));
        message.setContent((Multipart)multipart);
        message.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            message.writeTo(debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)this.getAddress());
        return message;
    }

    @Override
    protected AbstractMailEncryptor.EncryptorPropertiesData getPropertiesData() {
        AbstractMailEncryptor.EncryptorPropertiesData data = new AbstractMailEncryptor.EncryptorPropertiesData();
        data.allowCustomUserKey = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
        data.expireTimeStamp = PropertiesUtil.getAppProps().getLong("net.savignano.snotify.mailer.expireKeys.timeStamp");
        data.keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.class, this.getUser());
        data.timeStamp = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.pgp.timeStamp", this.getUser());
        return data;
    }
}

