/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.Signer;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6Server;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.SRP6GroupParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.AbstractTlsKeyExchange;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.Certificate;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.CertificateRequest;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.DefaultTlsSRPGroupVerifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.DigestInputBuffer;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.SecurityParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.ServerSRPParams;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.SignerInputBuffer;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsContext;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsCredentials;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsDSSSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsRSASigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsSRPUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected SRP6GroupParameters srpGroup = null;
    protected SRP6Client srpClient = null;
    protected SRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;
    protected BigInteger srpVerifier = null;
    protected byte[] srpSalt = null;
    protected TlsSignerCredentials serverCredentials = null;

    protected static TlsSigner createSigner(int keyExchange) {
        switch (keyExchange) {
            case 21: {
                return null;
            }
            case 23: {
                return new TlsRSASigner();
            }
            case 22: {
                return new TlsDSSSigner();
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, byte[] password) {
        this(keyExchange, supportedSignatureAlgorithms, new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsSRPGroupVerifier groupVerifier, byte[] identity, byte[] password) {
        super(keyExchange, supportedSignatureAlgorithms);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(keyExchange);
        this.groupVerifier = groupVerifier;
        this.identity = identity;
        this.password = password;
        this.srpClient = new SRP6Client();
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, TlsSRPLoginParameters loginParameters) {
        super(keyExchange, supportedSignatureAlgorithms);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(keyExchange);
        this.identity = identity;
        this.srpServer = new SRP6Server();
        this.srpGroup = loginParameters.getGroup();
        this.srpVerifier = loginParameters.getVerifier();
        this.srpSalt = loginParameters.getSalt();
    }

    public void init(TlsContext context) {
        super.init(context);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(context);
        }
    }

    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        net.savignano.thirdparty.org.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
        super.processServerCertificate(serverCertificate);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 21 || !(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        this.srpServer.init(this.srpGroup, this.srpVerifier, TlsUtils.createHash((short)2), this.context.getSecureRandom());
        BigInteger B = this.srpServer.generateServerCredentials();
        ServerSRPParams srpParams = new ServerSRPParams(this.srpGroup.getN(), this.srpGroup.getG(), this.srpSalt, B);
        DigestInputBuffer buf = new DigestInputBuffer();
        srpParams.encode(buf);
        if (this.serverCredentials != null) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
            Digest d = TlsUtils.createHash(signatureAndHashAlgorithm);
            SecurityParameters securityParameters = this.context.getSecurityParameters();
            d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
            d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
            buf.updateDigest(d);
            byte[] hash = new byte[d.getDigestSize()];
            d.doFinal(hash, 0);
            byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
            DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
            signed_params.encode(buf);
        }
        return buf.toByteArray();
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = null;
        InputStream teeIn = input;
        if (this.tlsSigner != null) {
            buf = new SignerInputBuffer();
            teeIn = new TeeInputStream(input, buf);
        }
        ServerSRPParams srpParams = ServerSRPParams.parse(teeIn);
        if (buf != null) {
            DigitallySigned signed_params = this.parseSignature(input);
            Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
            buf.updateSigner(signer);
            if (!signer.verifySignature(signed_params.getSignature())) {
                throw new TlsFatalAlert(51);
            }
        }
        this.srpGroup = new SRP6GroupParameters(srpParams.getN(), srpParams.getG());
        if (!this.groupVerifier.accept(this.srpGroup)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = srpParams.getS();
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), srpParams.getB());
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
        this.srpClient.init(this.srpGroup, TlsUtils.createHash((short)2), this.context.getSecureRandom());
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        BigInteger A = this.srpClient.generateClientCredentials(this.srpSalt, this.identity, this.password);
        TlsSRPUtils.writeSRPParameter(A, output);
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), TlsSRPUtils.readSRPParameter(input));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            BigInteger S = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
            return BigIntegers.asUnsignedByteArray(S);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

