/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common;

import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyUserProperties
implements ISnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyUserProperties.class);
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    @Override
    public boolean hasKey(String key, IUser user) {
        return this.getString(key, user) != null || this.getUnlimitedString(key, user) != null;
    }

    @Override
    public String getUnlimitedString(String key, IUser user) {
        if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, user)) {
            return null;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
        if (pagesValue == null) {
            return null;
        }
        int pages = pagesValue.intValue();
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = this.getString(key + SETTINGS_STRING_PAGE + i, user);
            builder.append(page);
        }
        String value = builder.toString();
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String key, IUser user) {
        return this.getBoolean(key, false, user);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, IUser user) {
        String value = this.getString(key, user);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Long getLong(String key, IUser user) {
        String value = this.getString(key, user);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Value " + value + " stored in user property " + key + " for user " + user + " is not a Long.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> clazz, IUser user) {
        String value = this.getString(key, user);
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value " + value + " stored in application property " + key + " for user " + user + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes(String key, IUser user) {
        String base64Value = this.getUnlimitedString(key, user);
        if (base64Value != null) {
            return Base64.decodeBase64((byte[])base64Value.getBytes(Constants.UTF8_CHARSET));
        }
        return null;
    }

    @Override
    public void setUnlimitedString(String key, String value, IUser user) {
        this.removeUnlimitedString(key, user);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255), user);
                }
                this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255), user);
            }
            this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages), user);
            this.setBoolean(key + SETTINGS_STRING_EXISTS, true, user);
        }
    }

    private void removeUnlimitedString(String key, IUser user) {
        if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, user)) {
            return;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
        if (pagesValue == null) {
            return;
        }
        this.setString(key + SETTINGS_STRING_EXISTS, null, user);
        this.setLong(key + SETTINGS_STRING_PAGES, null, user);
        int pages = pagesValue.intValue();
        for (int i = 0; i < pages; ++i) {
            this.setString(key + SETTINGS_STRING_PAGE + i, null, user);
        }
    }

    @Override
    public void setBoolean(String key, boolean value, IUser user) {
        this.setString(key, String.valueOf(value), user);
    }

    @Override
    public void setLong(String key, Long value, IUser user) {
        this.setString(key, value == null ? null : value.toString(), user);
    }

    @Override
    public void setEnum(String key, Enum<?> value, IUser user) {
        this.setString(key, value == null ? null : value.name(), user);
    }

    @Override
    public void setBytes(String key, byte[] value, IUser user) {
        String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Constants.UTF8_CHARSET);
        this.setUnlimitedString(key, encoded, user);
    }
}

