/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPObjectFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;

public class PgpUtil {
    public static final PGPPublicKeyRingCollection getPublicCollection(byte[] content) throws IOException, PGPException {
        try (InputStream decoderStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(content));){
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            return pGPPublicKeyRingCollection;
        }
    }

    public static final PGPPublicKey getPublicKey(byte[] content, long keyId) throws IOException, PGPException {
        PGPPublicKeyRingCollection collection = PgpUtil.getPublicCollection(content);
        return collection.getPublicKey(keyId);
    }

    public static final byte[] encrypt(MimeMessage msg, PGPPublicKey publicKey) throws IOException, PGPException, MessagingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        return PgpUtil.encrypt(baos.toString("UTF-8"), publicKey, 2, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] encrypt(String string, PGPPublicKey publicKey, int algorithm, boolean acsiiArmored, boolean zip) throws IOException, PGPException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        OutputStream out = null;
        OutputStream encDataGenOut = null;
        try {
            out = acsiiArmored ? new ArmoredOutputStream(byteOut) : byteOut;
            BcPGPDataEncryptorBuilder encBuilder = new BcPGPDataEncryptorBuilder(algorithm);
            encBuilder.setWithIntegrityPacket(true);
            BcPublicKeyKeyEncryptionMethodGenerator encMethodGen = new BcPublicKeyKeyEncryptionMethodGenerator(publicKey);
            PGPEncryptedDataGenerator encDataGen = new PGPEncryptedDataGenerator(encBuilder);
            encDataGen.addMethod(encMethodGen);
            encDataGenOut = encDataGen.open(out, new byte[65536]);
            if (zip) {
                PGPCompressedDataGenerator comDataGen = new PGPCompressedDataGenerator(1);
                OutputStream comDataOut = comDataGen.open(encDataGenOut);
                PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                OutputStream lDataOut = lDataGen.open(comDataOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);
                lDataOut.write(string.getBytes(Constants.UTF8_CHARSET));
                lDataOut.close();
                comDataGen.close();
            } else {
                PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                OutputStream lDataOut = lDataGen.open(encDataGenOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);
                lDataOut.write(string.getBytes(Constants.UTF8_CHARSET));
                lDataOut.close();
            }
        }
        finally {
            if (encDataGenOut != null) {
                encDataGenOut.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return byteOut.toByteArray();
    }

    public static final String decrypt(byte[] encryptedMessage, PGPSecretKeyRingCollection pgpSecretKeyRingCollection, char[] keyPassword) throws IOException, PGPException {
        Throwable throwable = null;
        try (InputStream decIn = PGPUtil.getDecoderStream(new ByteArrayInputStream(encryptedMessage));){
            BcKeyFingerprintCalculator fingerPrintCalculator = new BcKeyFingerprintCalculator();
            PGPObjectFactory pgpFactory = new PGPObjectFactory(decIn, (KeyFingerPrintCalculator)fingerPrintCalculator);
            Object obj = pgpFactory.nextObject();
            PGPEncryptedDataList encDataList = obj instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)obj : (PGPEncryptedDataList)pgpFactory.nextObject();
            PGPPrivateKey privateKey = null;
            PGPPublicKeyEncryptedData encData = null;
            Iterator encDataIter = encDataList.getEncryptedDataObjects();
            while (privateKey == null && encDataIter.hasNext()) {
                encData = (PGPPublicKeyEncryptedData)encDataIter.next();
                PGPSecretKey secretKey = pgpSecretKeyRingCollection.getSecretKey(encData.getKeyID());
                if (secretKey == null) continue;
                privateKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(keyPassword));
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("Secret key for message not found.");
            }
            BcPublicKeyDataDecryptorFactory decFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
            InputStream encDataIn = encData.getDataStream(decFactory);
            PGPObjectFactory objFact = new PGPObjectFactory(encDataIn, (KeyFingerPrintCalculator)fingerPrintCalculator);
            Object message = objFact.nextObject();
            if (message instanceof PGPCompressedData) {
                PGPCompressedData compressedData = (PGPCompressedData)message;
                PGPObjectFactory compressedFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)fingerPrintCalculator);
                message = compressedFact.nextObject();
            }
            if (encData.isIntegrityProtected() && !encData.verify()) {
                encDataIn.close();
                throw new PGPException("Message failed integrity check.");
            }
            encDataIn.close();
            if (message instanceof PGPLiteralData) {
                int ch;
                PGPLiteralData literalData = (PGPLiteralData)message;
                InputStream literalDataIn = literalData.getInputStream();
                ByteArrayOutputStream decOut = new ByteArrayOutputStream();
                while ((ch = literalDataIn.read()) >= 0) {
                    decOut.write(ch);
                }
                literalDataIn.close();
                String string = decOut.toString("UTF-8");
                return string;
            }
            try {
                if (message instanceof PGPOnePassSignatureList) {
                    throw new PGPException("Encrypted message contains a signed message - not literal data.");
                }
                throw new PGPException("Message is not a simple encrypted file - type unknown: " + message);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static final String getPrettyId(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        return Long.toHexString(key.getKeyID()).toUpperCase();
    }
}

