/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encryptor;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.mailer.encryptor.IMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMailEncryptor<T extends ISnotifyKey<?>>
implements IMailEncryptor<T> {
    public static final String XENCRPYTED_MAIL_PROPERTY = "X-Encrypted";
    private static final long EXPIRE_DURATION = 43200000L;
    private static final Logger log = LoggerFactory.getLogger(AMailEncryptor.class);
    private final Session session;
    private final Address address;
    private final MimeMessage message;
    private EncryptorData encryptorData;
    private IUser user;
    private String hostName;
    private T publicKey;

    public AMailEncryptor(Session session, MimeMessage message, Address address) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message must not be null.");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address must not be null.");
        }
        this.session = session;
        this.message = message;
        this.address = address;
        this.setHostName("<Unknown>");
    }

    @Override
    public MimeMessage getEncryptedMessage() throws IOException, MessagingException {
        if (this.getPublicKey().getKeyValidity() != EKeyValidity.VALID) {
            throw new MessagingException("Can not encrypt message to address " + this.address + " because of key having validity: " + (Object)((Object)this.getPublicKey().getKeyValidity()));
        }
        return this.encrypt();
    }

    protected abstract MimeMessage encrypt() throws IOException, MessagingException;

    protected T loadPublicKey() {
        boolean isGetRepositoryKey;
        if (this.getUser() == null) {
            return this.getValidityKey(EKeyValidity.ERROR, EncryptionKeySource.UNKNOWN);
        }
        EncryptorData data = this.getEncryptorData();
        log.debug("Used properties for determining validity of key: {}", (Object)data);
        if (log.isTraceEnabled()) {
            log.trace("Used properties for determining validity of key (verbose): {}", (Object)data.toString(false));
        }
        T publicKey = this.getUserPublicKey();
        if (data.isLiteVersion) {
            isGetRepositoryKey = false;
            if (data.keySource != EncryptionKeySource.USER) {
                publicKey = this.getValidityKey(EKeyValidity.NOT_FOUND, data.keySource);
            }
        } else {
            switch (publicKey.getKeyValidity()) {
                case VALID: {
                    isGetRepositoryKey = data.keySource == EncryptionKeySource.USER ? !data.allowCustomUserKey : data.expireTimeStamp != null && (data.timeStamp == null || data.expireTimeStamp > data.timeStamp);
                    log.debug("Does valid key from source {} need to be loaded from repository: {}", (Object)data.keySource, (Object)isGetRepositoryKey);
                    break;
                }
                case INVALID: 
                case NOT_FOUND: {
                    isGetRepositoryKey = data.timeStamp == null || System.currentTimeMillis() > data.timeStamp + 43200000L || data.expireTimeStamp != null && data.expireTimeStamp > data.timeStamp;
                    log.debug("Key can't be used. Need to be loaded from repository: {}", (Object)isGetRepositoryKey);
                    break;
                }
                case ERROR: {
                    isGetRepositoryKey = true;
                    break;
                }
                default: {
                    log.error("Unknown validity enum value: {}", (Object)publicKey.getKeyValidity());
                    isGetRepositoryKey = true;
                }
            }
        }
        if (isGetRepositoryKey && (publicKey = this.getRepositoryPublicKey()).getKeyValidity() != EKeyValidity.ERROR) {
            try {
                this.storePublicKey(publicKey);
            }
            catch (IOException e) {
                log.error("Public key could not be stored for user " + this.getUser() + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return publicKey;
    }

    protected T getRepositoryPublicKey() {
        if (this.getEncryptorData().isLiteVersion) {
            log.debug("Lite version, no key will be search in repositories.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND, EncryptionKeySource.UNKNOWN);
        }
        ISnotifyKey bestKey = null;
        for (IKeyLoader<T> keyLoader : this.getKeyLoaders()) {
            T key;
            try {
                key = keyLoader.loadKey();
            }
            catch (Exception e) {
                log.error("Unexpected error retrieving key from: " + keyLoader + ". Error message: " + e.getMessage(), (Throwable)e);
                key = this.getValidityKey(EKeyValidity.ERROR, keyLoader.getKeySource());
            }
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = (ISnotifyKey)key;
                break;
            }
            if (bestKey == null) {
                bestKey = (ISnotifyKey)key;
                continue;
            }
            if (key.getKeyValidity().ordinal() >= bestKey.getKeyValidity().ordinal()) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = (ISnotifyKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EncryptionKeySource.UNKNOWN);
        }
        log.debug("Found Repository key: {}", bestKey);
        return (T)bestKey;
    }

    protected abstract Collection<IKeyLoader<T>> getKeyLoaders();

    protected abstract T getValidityKey(EKeyValidity var1, EncryptionKeySource var2);

    protected abstract T getUserPublicKey();

    protected abstract void storePublicKey(T var1) throws IOException;

    protected abstract EncryptorData loadEncryptorData();

    public EncryptorData getEncryptorData() {
        if (this.encryptorData == null) {
            this.encryptorData = this.loadEncryptorData();
        }
        return this.encryptorData;
    }

    @Override
    public T getPublicKey() {
        if (this.publicKey == null) {
            this.setPublicKey(this.loadPublicKey());
        }
        return this.publicKey;
    }

    public void setPublicKey(T publicKey) {
        this.publicKey = publicKey;
    }

    public Session getSession() {
        return this.session;
    }

    public Address getAddress() {
        return this.address;
    }

    public IUser getUser() {
        if (this.user == null) {
            this.user = this.loadUser();
        }
        return this.user;
    }

    protected abstract IUser loadUser();

    public MimeMessage getMessage() {
        return this.message;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public static class EncryptorData {
        public Long expireTimeStamp;
        public Long timeStamp;
        public EncryptionKeySource keySource;
        public boolean allowCustomUserKey;
        public boolean isLiteVersion;

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean userFriendlyDates) {
            if (userFriendlyDates) {
                return "EncryptorPropertiesData [expireRepositoryData=" + (this.expireTimeStamp == null ? null : new Date(this.expireTimeStamp)) + ", timeStamp=" + (this.timeStamp == null ? null : new Date(this.timeStamp)) + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", isLiteVersion=" + this.isLiteVersion + ", currentTime=" + new Date(System.currentTimeMillis()) + "]";
            }
            return "EncryptorPropertiesData [expireRepositoryData=" + this.expireTimeStamp + ", timeStamp=" + this.timeStamp + ", keySource=" + (Object)((Object)this.keySource) + ", allowCustomUserKey=" + this.allowCustomUserKey + ", isLiteVersion=" + this.isLiteVersion + ", currentTime=" + System.currentTimeMillis() + "]";
        }
    }
}

