/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.SnotifySmimeKey;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeKeyStoreLoader
implements IKeyLoader<SnotifySmimeKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeKeyStoreLoader.class);
    private final KeyStore keyStore;
    private final String email;

    public SmimeKeyStoreLoader(KeyStore keyStore, String email) {
        this.keyStore = keyStore;
        this.email = email;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    public SnotifySmimeKey loadKey() {
        log.info("Looking up S/MIME certificate for email {} in key store.", (Object)this.getEmail());
        X509Certificate certificate = CertUtil.getValidCertForEmail(this.getKeyStore(), this.getEmail());
        if (certificate != null) {
            log.info("Found valid S/MIME certificate for email {} in key store.", (Object)this.getEmail());
            log.trace("Found certificate: {}", (Object)certificate);
            SnotifySmimeKey key = new SnotifySmimeKey(certificate, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        try {
            certificate = CertUtil.getCertForEmail(this.getKeyStore(), this.getEmail());
        }
        catch (KeyStoreException | CertificateException e) {
            log.warn("Could not load certificate from key store for email " + this.getEmail() + ".", (Throwable)e);
            return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
        }
        log.info("Found no valid S/MIME certificate for email {} in key store.", (Object)this.getEmail());
        log.trace("Found certificate: {}", (Object)certificate);
        SnotifySmimeKey key = certificate == null ? new SnotifySmimeKey(EKeyValidity.NOT_FOUND) : new SnotifySmimeKey(certificate);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    public EncryptionKeySource getKeySource() {
        return EncryptionKeySource.KEYSTORE;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "Key Store: " + this.keyStore;
    }
}

