/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.enums.EncryptionFailureBehaviorOption;
import net.savignano.snotify.atlassian.common.enums.EncryptionTypePriorityOption;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.mailer.AMailer;
import net.savignano.snotify.confluence.mailer.security.PgpMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.SmimeMailEncryptor;
import net.savignano.snotify.confluence.mailer.util.MessageUtil;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailer
extends AMailer {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailer.class);
    private KeyStore keyStore;

    private static KeyStore loadKeyStore(String location, String password, Provider provider) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (location == null || location.isEmpty()) {
            log.debug("No location given. No S/MIME keystore loaded.");
            return null;
        }
        if (provider == null || location.isEmpty()) {
            log.debug("No provider given. No S/MIME keystore loaded.");
            return null;
        }
        KeyStore ks = KeyStore.getInstance("BKS", provider);
        log.debug("Loading keystore from location: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            ks.load(in, password == null ? null : password.toCharArray());
        }
        log.debug("Loaded keystore from location \"{}\" succesfully.", (Object)location);
        return ks;
    }

    @Override
    protected Message getFailureMessage(Session session, Message message, EKeyValidity validity) throws MessagingException {
        if (validity == EKeyValidity.ERROR) {
            return MessageUtil.createInternalErrorInfoMail(message, session);
        }
        return MessageUtil.createMissingKeyInfoMail(message, session);
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Session session, MimeMessage orgMsg, Address address) {
        SmimeMailEncryptor smimeEncryptor = new SmimeMailEncryptor(session, orgMsg, address);
        smimeEncryptor.setHostName(this.getHostName());
        smimeEncryptor.setKeyStore(this.getKeyStore());
        return smimeEncryptor;
    }

    protected PgpMailEncryptor getPgpEncryptor(Session session, MimeMessage orgMsg, Address address) {
        PgpMailEncryptor pgpEncryptor = new PgpMailEncryptor(session, orgMsg, address);
        pgpEncryptor.setHostName(this.getHostName());
        return pgpEncryptor;
    }

    public KeyStore getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = this.loadKeyStore();
        }
        return this.keyStore;
    }

    protected KeyStore loadKeyStore() {
        String location = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystoreLocation");
        String password = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystorePassword");
        try {
            return ConfluenceMailer.loadKeyStore(location, password, this.getProvider());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Could not load keystore from location: " + location, (Throwable)e);
            return null;
        }
    }

    @Override
    protected EncryptionTypePriorityOption loadTypePriority() {
        EncryptionTypePriorityOption encryptionTypePriority = PropertiesUtil.getAppProps().getEnum("net.savignano.snotify.mailer.encryptionTypePriority", EncryptionTypePriorityOption.class);
        if (encryptionTypePriority == null) {
            encryptionTypePriority = super.loadTypePriority();
        }
        return encryptionTypePriority;
    }

    @Override
    protected EncryptionFailureBehaviorOption loadFailureBehavior() {
        EncryptionFailureBehaviorOption encryptionFailure = PropertiesUtil.getAppProps().getEnum("net.savignano.snotify.mailer.encryptionFailureBehavior", EncryptionFailureBehaviorOption.class);
        if (encryptionFailure == null) {
            encryptionFailure = super.loadFailureBehavior();
        }
        return encryptionFailure;
    }

    @Override
    protected boolean loadDisabled() {
        return PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.mailer.disable");
    }

    @Override
    protected boolean loadFrozen() {
        return PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.mailer.freeze");
    }
}

