/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.sun.mail.smtp.SMTPSSLTransport;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.confluence.mailer.ConfluenceMailer;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPSTransport
extends SMTPSSLTransport {
    private static final Logger log = LoggerFactory.getLogger(SMTPSTransport.class);
    private final ConfluenceMailer mailer = new ConfluenceMailer();

    public SMTPSTransport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException {
        MessageAndAddress[] result;
        log.info("Using S/Notify SMTPS transport implementation to send emails.");
        log.trace("Session properties used: {}", (Object)this.session.getProperties());
        try {
            result = this.mailer.getMessages(this.session, message, addresses);
        }
        catch (Exception e) {
            throw new MessagingException("Error generating emails: " + e.getMessage(), e);
        }
        if (PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.tweak.dryRunMailer")) {
            log.info("S/Notify Mailer is in 'Dry Run'-mode. No emails will be delivered.");
        } else {
            this.sendEmails(result);
        }
    }

    private void sendEmails(MessageAndAddress[] emails) throws MessagingException {
        ArrayList<MessagingException> messagingExceptions = new ArrayList<MessagingException>();
        for (MessageAndAddress messageAndAddress : emails) {
            if (messageAndAddress == null) continue;
            try {
                log.debug("Delivering email to: " + messageAndAddress.address);
                super.sendMessage(messageAndAddress.message, new Address[]{messageAndAddress.address});
            }
            catch (MessagingException e) {
                messagingExceptions.add(e);
            }
        }
        if (!messagingExceptions.isEmpty()) {
            for (MessagingException e : messagingExceptions) {
                log.error(e.getMessage(), (Throwable)e);
            }
            MessagingException e = (MessagingException)((Object)messagingExceptions.get(0));
            throw new MessagingException("Error sending mail: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

