/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.component.ComponentLocator;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyAppProperties
extends ASnotifyAppProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyAppProperties.class);
    private final BandanaManager manager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);

    @Override
    public String getString(String key) {
        String value;
        try {
            value = (String)this.manager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        }
        catch (ClassCastException e) {
            log.error("ClassCastException loading application property " + key + ".", (Throwable)e);
            this.manager.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.trace("App property \"{}\" is considered null.", (Object)key);
            return null;
        }
        log.trace("App property \"{}\" is: {}", (Object)key, (Object)value);
        return value;
    }

    @Override
    public void setString(String key, String value) {
        Object oldValue = this.manager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        if (!(oldValue == null || value != null && oldValue instanceof String)) {
            log.trace("Removing app property \"{}\".", (Object)key);
            this.manager.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        }
        if (value != null) {
            log.trace("Setting app property \"{}\" to: {}", (Object)key, (Object)value);
            this.manager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key, (Object)value);
        }
        if (log.isTraceEnabled()) {
            Object newValue = this.manager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            if (value == null ? newValue != null : !value.equals(newValue)) {
                log.error("Setting of app property \"{}\" failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, value, newValue});
            }
        }
    }
}

