/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.key.SnotifySmimeKey;
import net.savignano.snotify.atlassian.mailer.encryptor.ASmimeMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeLdapLoader;
import net.savignano.snotify.confluence.mailer.ConfluenceUser;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailEncryptor
extends ASmimeMailEncryptor {
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify for Confluence at {0} using S/MIME encryption with {1}";
    private static final Logger log = LoggerFactory.getLogger(SmimeMailEncryptor.class);

    private static final ConfluenceUser getUserForAddress(Address address) {
        String email = address.toString();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        SearchResult searchResult = userAccessor.getUsersByEmail(email);
        Iterator users = searchResult.pager().iterator();
        if (users.hasNext()) {
            User user = (User)users.next();
            log.debug("Found user {} for email \"{}\".", (Object)user, (Object)email);
            if (users.hasNext()) {
                ArrayList<Object> logUsers = new ArrayList<Object>();
                logUsers.add(user);
                while (users.hasNext()) {
                    logUsers.add(users.next());
                }
                log.warn("Multiple users found for email \"{}\". First user found used for encryption purposes, but this can be unpredictable: {}", (Object)email, logUsers);
            }
            return new ConfluenceUser(user);
        }
        log.error("No user found for email: {}", (Object)email);
        return null;
    }

    public SmimeMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected String getXencryptedMailValue(String encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), encryptionAlgorithm);
    }

    @Override
    public ConfluenceUser getUser() {
        return (ConfluenceUser)super.getUser();
    }

    @Override
    protected ConfluenceUser loadUser() {
        return SmimeMailEncryptor.getUserForAddress(this.getAddress());
    }

    @Override
    protected IKeyLoader<SnotifySmimeKey> createLdapLoader() {
        Directory directory;
        EmbeddedCrowdUser user;
        if (!this.getAppProperties().getBoolean("net.savignano.snotify.ldap.smime.query")) {
            log.debug("Retrieving certificate from LDAP server is disabled.");
            return null;
        }
        EmbeddedCrowdUser embeddedCrowdUser = user = this.getUser() == null ? null : this.getCrowdUser(this.getUser().getActualUser());
        if (user == null) {
            log.debug("Could not find a crowd user for user: {}", (Object)this.getUser());
            return null;
        }
        long directoryId = user.getDirectoryId();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
        SmimeLdapLoader loader = SmimeLdapLoader.createLoader(directory);
        if (loader != null) {
            loader.setUserName(userName);
            loader.setEmail(this.getAddress().toString());
            loader.setExpectP7b(this.getAppProperties().getBoolean("net.savignano.snotify.tweak.expectP7bInLdap"));
        }
        return loader;
    }

    private EmbeddedCrowdUser getCrowdUser(User user) {
        if (user instanceof EmbeddedCrowdUser) {
            return (EmbeddedCrowdUser)user;
        }
        if (user instanceof ConfluenceUserImpl) {
            return this.getCrowdUser(((ConfluenceUserImpl)user).getBackingUser());
        }
        return null;
    }

    @Override
    protected ISnotifyAppProperties getAppProperties() {
        return PropertiesUtil.getAppProps();
    }

    @Override
    protected ISnotifyUserProperties getUserProperties() {
        return PropertiesUtil.getUserProps();
    }
}

