/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSAPublicBCPGKey;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream in) throws IOException {
        this.version = in.read();
        this.time = (long)in.read() << 24 | (long)(in.read() << 16) | (long)(in.read() << 8) | (long)in.read();
        if (this.version <= 3) {
            this.validDays = in.read() << 8 | in.read();
        }
        this.algorithm = (byte)in.read();
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(in);
                break;
            }
            case 17: {
                this.key = new DSAPublicBCPGKey(in);
                break;
            }
            case 16: 
            case 20: {
                this.key = new ElGamalPublicBCPGKey(in);
                break;
            }
            case 18: {
                this.key = new ECDHPublicBCPGKey(in);
                break;
            }
            case 19: {
                this.key = new ECDSAPublicBCPGKey(in);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public PublicKeyPacket(int algorithm, Date time, BCPGKey key) {
        this.version = 4;
        this.time = time.getTime() / 1000L;
        this.algorithm = algorithm;
        this.key = key;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write((byte)(this.time >> 24));
        pOut.write((byte)(this.time >> 16));
        pOut.write((byte)(this.time >> 8));
        pOut.write((byte)this.time);
        if (this.version <= 3) {
            pOut.write((byte)(this.validDays >> 8));
            pOut.write((byte)this.validDays);
        }
        pOut.write(this.algorithm);
        pOut.writeObject((BCPGObject)((Object)this.key));
        pOut.close();
        return bOut.toByteArray();
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(6, this.getEncodedContents(), true);
    }
}

