/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.connector;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnector {
    private static final String DEFAULT_USERNAME_KEY = "uid";
    private static final String LDAP_URL_PROP = "ldap.url";
    private static final String LDAP_BASEDN_PROP = "ldap.basedn";
    private static final String LDAP_USERDN_PROP = "ldap.user.dn";
    private static final String LDAP_USERNAME_PROP = "ldap.user.username";
    private static final Logger log = LoggerFactory.getLogger(LdapConnector.class);
    private String userNameKey = "uid";
    private String ldapUrl;
    private String userBase;
    private DirContext context;

    public static boolean isConnector(Directory directory) {
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            if (log.isDebugEnabled()) {
                if (directory == null) {
                    log.debug("Null directory given.");
                } else if (!directory.isActive()) {
                    log.debug("Directory {} is not active.", (Object)directory.getName());
                } else if (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
                    log.debug("Directory {} is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: {}", (Object)directory.getName(), (Object)directory.getType());
                } else {
                    log.debug("Unknown reason why 'createLoader' is skipped. Probably implementation problem.");
                }
            }
            return false;
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        boolean isLdap = !StringUtils.isBlank((String)ldapUrl) && !StringUtils.isBlank((String)ldapBaseDn);
        log.debug("Directory {} is considered to be an LDAP: {}", (Object)directory.getName(), (Object)isLdap);
        return isLdap;
    }

    public static LdapConnector createConnector(Directory directory) throws ConfigurationException {
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            String reason = directory == null ? "Null directory given." : (!directory.isActive() ? "Directory " + directory.getName() + " is not active." : (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING ? "Directory " + directory.getName() + " is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: " + directory.getType() : "Unknown reason why data extraction is skipped. Probably implementation problem."));
            throw new ConfigurationException(reason);
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        log.trace("LDAP URL: {}", (Object)ldapUrl);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        log.trace("LDAP Base DN: {}", (Object)ldapBaseDn);
        String ldapUserDn = directory.getValue(LDAP_USERDN_PROP);
        log.trace("LDAP User DN: {}", (Object)ldapUserDn);
        String ldapUserNameKey = directory.getValue(LDAP_USERNAME_PROP);
        log.trace("LDAP User Name Key: {}", (Object)ldapUserNameKey);
        if (StringUtils.isBlank((String)ldapUrl) || StringUtils.isBlank((String)ldapBaseDn)) {
            throw new ConfigurationException("Could not extract needed keys from this directory. Is probably not connecting to an LDAP.");
        }
        String userBase = ldapBaseDn;
        if (StringUtils.isNotBlank((String)ldapUserDn)) {
            userBase = ldapUserDn + "," + userBase;
        }
        LdapConnector connector = new LdapConnector();
        connector.setLdapUrl(ldapUrl);
        connector.setUserBase(userBase);
        if (StringUtils.isNotBlank((String)ldapUserNameKey)) {
            connector.setUserNameKey(ldapUserNameKey);
        }
        return connector;
    }

    public void connect() throws NamingException {
        this.connect(null);
    }

    public void connect(Map<String, String> envMap) throws NamingException {
        this.disconnect();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.getLdapUrl());
        if (envMap != null) {
            env.putAll(envMap);
        }
        this.setContext(new InitialDirContext(env));
    }

    public void disconnect() {
        this.setContext(null);
    }

    public DirContext getContext() {
        return this.context;
    }

    protected void setContext(DirContext context) {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.context = context;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserNameKey() {
        return this.userNameKey;
    }

    public void setUserNameKey(String userNameKey) {
        this.userNameKey = userNameKey == null ? DEFAULT_USERNAME_KEY : userNameKey;
    }

    public String toString() {
        return "LdapConnector [userNameKey=" + this.userNameKey + ", ldapUrl=" + this.ldapUrl + ", userBase=" + this.userBase + "]";
    }
}

