/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpKey
extends ASnotifyKey<PGPPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpKey.class);
    private final PGPPublicKeyRing ring;
    private final PGPPublicKey masterKey;
    private final PGPPublicKey encryptionKey;

    private static PGPPublicKey findMasterKey(PGPPublicKeyRing ring) {
        for (PGPPublicKey key : ring) {
            if (!key.isMasterKey()) continue;
            log.debug("Master key ID: {}", (Object)PgpUtil.getPrettyId(key));
            return key;
        }
        log.error("Could not find master key in key ring.");
        return null;
    }

    private static boolean isKeyForEmail(PGPPublicKey key, String email) {
        String lcEmail = email.toLowerCase(Locale.ROOT);
        Iterator<String> iter = key.getUserIDs();
        while (iter.hasNext()) {
            if (!iter.next().toLowerCase(Locale.ROOT).contains(lcEmail)) continue;
            return true;
        }
        return false;
    }

    private static PGPPublicKey findEncryptionKey(PGPPublicKeyRing ring) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        for (PGPPublicKey key : ring) {
            if (!SnotifyPgpKey.isValidEncryptionKey(key)) continue;
            keys.add(key);
        }
        PGPPublicKey newestKey = null;
        for (PGPPublicKey key : keys) {
            if (newestKey != null && !newestKey.getCreationTime().before(key.getCreationTime())) continue;
            newestKey = key;
        }
        if (log.isDebugEnabled()) {
            if (newestKey == null) {
                log.debug("No key found that can be used for encryption. Master key ID: {}", (Object)PgpUtil.getPrettyId(SnotifyPgpKey.findMasterKey(ring)));
            } else {
                log.debug("Using key with ID {}. Creation time: {}", (Object)Long.toHexString(newestKey.getKeyID()).toUpperCase(), (Object)newestKey.getCreationTime());
            }
        }
        return newestKey;
    }

    private static boolean isValidEncryptionKey(PGPPublicKey key) {
        boolean valid;
        String prettyKeyId = PgpUtil.getPrettyId(key);
        if (!key.isEncryptionKey()) {
            log.debug("Algorithm for key with ID {} can not be used for encryption.", (Object)prettyKeyId);
            return false;
        }
        boolean keyFlagsUsed = false;
        boolean encryptionFlag = false;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
            if (packets == null) continue;
            int keyFlags = packets.getKeyFlags();
            boolean bl = keyFlagsUsed = keyFlagsUsed || keyFlags != 0;
            if ((keyFlags & 4) == 0) continue;
            encryptionFlag = true;
            break;
        }
        if (!encryptionFlag && keyFlagsUsed) {
            log.debug("Key with ID {} has not the necessary flags for an encryption key.", (Object)prettyKeyId);
            return false;
        }
        if (key.hasRevocation()) {
            log.debug("Key with ID {} has been revoked.", (Object)prettyKeyId);
            return false;
        }
        long validSeconds = key.getValidSeconds();
        boolean bl = valid = validSeconds == 0L || validSeconds * 1000L + key.getCreationTime().getTime() >= System.currentTimeMillis();
        if (!valid) {
            log.debug("Key with ID {} is no loger valid. Expired: {}", (Object)prettyKeyId, (Object)new Date(validSeconds * 1000L + key.getCreationTime().getTime()));
            return false;
        }
        log.debug("Key with ID {} can be used for encryption.", (Object)prettyKeyId);
        return true;
    }

    public SnotifyPgpKey(PGPPublicKeyRingCollection collection, String email) {
        if (collection == null) {
            throw new IllegalArgumentException("Key ring collection must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email address must not be null.");
        }
        log.debug("Looking up key ring for email {}.", (Object)email);
        PGPPublicKeyRing matchedRing = null;
        PGPPublicKey matchedMasterKey = null;
        Iterator<PGPPublicKeyRing> iterRing = collection.iterator();
        while (iterRing.hasNext() && matchedRing == null) {
            PGPPublicKeyRing ring = iterRing.next();
            PGPPublicKey key = SnotifyPgpKey.findMasterKey(ring);
            if (key == null) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (SnotifyPgpKey.isKeyForEmail(key, email)) {
                log.debug("Master key (ID: {}) is valid for email {}.", (Object)PgpUtil.getPrettyId(key), (Object)email);
                matchedRing = ring;
                matchedMasterKey = key;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            ArrayList<String> ids = new ArrayList<String>();
            Iterator<String> iter = key.getUserIDs();
            while (iter.hasNext()) {
                ids.add(iter.next());
            }
            String prettyKeyId = PgpUtil.getPrettyId(key);
            if (ids.isEmpty()) {
                log.debug("Key with ID {} does not contain any user IDs.", (Object)prettyKeyId);
                continue;
            }
            log.debug("Key with ID {} does not match email {}. It has the following user IDs: {}", new Object[]{prettyKeyId, email, ids});
        }
        if (matchedRing != null) {
            this.ring = matchedRing;
            this.masterKey = matchedMasterKey;
            this.encryptionKey = SnotifyPgpKey.findEncryptionKey(matchedRing);
            if (this.encryptionKey == null) {
                log.warn("No valid encryption key was found to encrypt emails. Corresponding master key ID: {}", (Object)PgpUtil.getPrettyId(this.masterKey));
                this.setKeyValidity(EKeyValidity.INVALID);
            }
        } else {
            log.warn("No matching key ring found for email address: {}", (Object)email);
            this.ring = null;
            this.masterKey = null;
            this.encryptionKey = null;
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifyPgpKey(PGPPublicKeyRing ring) {
        this(ring, null);
    }

    public SnotifyPgpKey(PGPPublicKeyRing ring, String email) {
        if (ring == null) {
            throw new IllegalArgumentException("Key ring must not be null.");
        }
        this.ring = ring;
        this.masterKey = SnotifyPgpKey.findMasterKey(ring);
        this.encryptionKey = SnotifyPgpKey.findEncryptionKey(ring);
        if (this.masterKey == null) {
            log.warn("Passed key ring has no master key. Maybe key ring is corrupt.");
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (this.encryptionKey == null) {
            log.warn("No valid encryption key was found to encrypt emails. Corresponding master key ID: {}", (Object)PgpUtil.getPrettyId(this.masterKey));
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (email != null && !SnotifyPgpKey.isKeyForEmail(this.masterKey, email)) {
            log.warn("Key ring is no match for email address: {}", (Object)email);
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifyPgpKey(EKeyValidity validity) {
        this.ring = null;
        this.masterKey = null;
        this.encryptionKey = null;
        this.setKeyValidity(validity);
    }

    public SnotifyPgpKey(EKeyValidity validity, EncryptionKeySource keySource) {
        this.ring = null;
        this.masterKey = null;
        this.encryptionKey = null;
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        if (this.ring == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.ring.encode(baos, true);
        return baos.toByteArray();
    }

    public PGPPublicKey getMasterKey() {
        return this.masterKey;
    }

    @Override
    public PGPPublicKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public PGPPublicKey getKey(long keyId) {
        if (this.ring == null) {
            return null;
        }
        return this.ring.getPublicKey(keyId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Encryption Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getEncryptionKey()));
        builder.append("; Master Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getMasterKey()));
        return builder.toString();
    }
}

