/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encryptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.SnotifyPgpKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import net.savignano.snotify.atlassian.mailer.encryptor.AMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpKeyServerLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APgpMailEncryptor
extends AMailEncryptor<SnotifyPgpKey> {
    private static final Logger log = LoggerFactory.getLogger(APgpMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify at {0} using PGP encryption with {1}";

    public APgpMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected SnotifyPgpKey getValidityKey(EKeyValidity validity, EncryptionKeySource keySource) {
        return new SnotifyPgpKey(validity, keySource);
    }

    @Override
    protected MimeMessage encrypt() throws IOException, MessagingException {
        String encryptedMessage;
        PGPPublicKey encryptionKey = ((SnotifyPgpKey)this.getPublicKey()).getEncryptionKey();
        log.debug("Encrypting email to \"{}\" with public key: {}", (Object)this.getAddress(), (Object)Long.toHexString(encryptionKey.getKeyID()).toUpperCase());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            this.getMessage().writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        SnotifyMimeMessage sMsg = new SnotifyMimeMessage(this.getMessage());
        try {
            encryptedMessage = new String(PgpUtil.encrypt(sMsg, encryptionKey), StandardCharsets.US_ASCII);
            log.trace("Encrypted message: {}", (Object)encryptedMessage);
        }
        catch (PGPException e) {
            throw new MessagingException(e.getLocalizedMessage(), (Exception)e);
        }
        MimeBodyPart partVersion = new MimeBodyPart();
        partVersion.setContent((Object)"Version: 1\n", "application/pgp-encrypted");
        MimeBodyPart partEncrypted = new MimeBodyPart();
        partEncrypted.setContent((Object)encryptedMessage, "application/octet-stream");
        partEncrypted.setDisposition("inline");
        MimeMultipart multipart = new MimeMultipart("encrypted"){

            public synchronized String getContentType() {
                return super.getContentType() + ";\n\tprotocol=\"application/pgp-encrypted\"";
            }
        };
        multipart.addBodyPart((BodyPart)partVersion);
        multipart.addBodyPart((BodyPart)partEncrypted);
        SnotifyMimeMessage message = new SnotifyMimeMessage(this.getSession());
        Enumeration iter = this.getMessage().getAllHeaderLines();
        while (iter.hasMoreElements()) {
            message.addHeaderLine((String)iter.nextElement());
        }
        message.addHeader("X-Encrypted", this.getXencryptedMailValue("AES128"));
        message.setContent((Multipart)multipart);
        message.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            message.writeTo(debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)this.getAddress());
        return message;
    }

    @Override
    protected List<IKeyLoader<SnotifyPgpKey>> getKeyLoaders() {
        ArrayList<IKeyLoader<SnotifyPgpKey>> loaders = new ArrayList<IKeyLoader<SnotifyPgpKey>>();
        IKeyLoader<SnotifyPgpKey> keyServerLoader = this.createKeyServerLoader();
        if (keyServerLoader != null) {
            loaders.add(keyServerLoader);
        }
        return loaders;
    }

    private IKeyLoader<SnotifyPgpKey> createKeyServerLoader() {
        String keyServer = this.getAppProperties().getString("net.savignano.snotify.pgp.keyserverLocation");
        if (keyServer == null) {
            log.debug("No key server configured to retrieve PGP public keys from.");
            return null;
        }
        boolean encodeSearchParam = !this.getAppProperties().getBoolean("net.savignano.snotify.tweak.doNotEncodePgpSearchParam");
        Long timeout = this.getAppProperties().getLong("net.savignano.snotify.tweak.urlConnectionTimeoutDuringMailing");
        PgpKeyServerLoader loader = new PgpKeyServerLoader(keyServer, this.getAddress().toString());
        loader.setEncodeSearchParam(encodeSearchParam);
        if (timeout != null && timeout.intValue() >= 0) {
            loader.setTimeout(timeout.intValue());
        }
        return loader;
    }

    @Override
    protected SnotifyPgpKey getUserPublicKey() {
        Long keyId = this.getUserProperties().getLong("net.savignano.snotify.email.pgp.key.id", this.getUser());
        byte[] keyBytes = this.getUserProperties().getBytes("net.savignano.snotify.email.pgp.key", this.getUser());
        if (keyId != null && keyBytes != null) {
            log.debug("Using public key of user {} for encrypting email to \"{}\".", (Object)this.getUser(), (Object)this.getAddress());
            try {
                SnotifyPgpKey key = new SnotifyPgpKey(PgpUtil.getPublicCollection(keyBytes), this.getAddress().toString());
                key.setKeySource(EncryptionKeySource.USER);
                return key;
            }
            catch (IOException | PGPException e) {
                log.error("Could not load public key of user " + this.getUser() + " because an exception occured.", (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR, EncryptionKeySource.USER);
            }
        }
        log.debug("User {} has no public key stored.", (Object)this.getUser());
        return this.getValidityKey(EKeyValidity.NOT_FOUND, EncryptionKeySource.USER);
    }

    @Override
    protected void storePublicKey(SnotifyPgpKey key) throws IOException {
        log.debug("Storing new PGP key to user properties: {}", (Object)key.getMasterKey());
        PGPPublicKey encryptionKey = key.getEncryptionKey();
        this.getUserProperties().setBytes("net.savignano.snotify.email.pgp.key", key.getEncoded(), this.getUser());
        this.getUserProperties().setLong("net.savignano.snotify.email.pgp.key.id", encryptionKey == null ? null : Long.valueOf(encryptionKey.getKeyID()), this.getUser());
        this.getUserProperties().setLong("net.savignano.snotify.email.pgp.timeStamp", System.currentTimeMillis(), this.getUser());
        this.getUserProperties().setEnum("net.savignano.snotify.email.pgp.keySource", key.getKeySource(), this.getUser());
    }

    @Override
    protected AMailEncryptor.EncryptorData loadEncryptorData() {
        AMailEncryptor.EncryptorData data = new AMailEncryptor.EncryptorData();
        data.allowCustomUserKey = this.getAppProperties().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
        data.expireTimeStamp = this.getAppProperties().getLong("net.savignano.snotify.mailer.expireKeys.timeStamp");
        data.keySource = this.getUserProperties().getEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.class, this.getUser());
        data.timeStamp = this.getUserProperties().getLong("net.savignano.snotify.email.pgp.timeStamp", this.getUser());
        data.isLiteVersion = this.getAppProperties().getBoolean("net.savignano.snotify.lite.mode");
        return data;
    }

    protected String getXencryptedMailValue(String encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), encryptionAlgorithm);
    }

    protected abstract ISnotifyAppProperties getAppProperties();

    protected abstract ISnotifyUserProperties getUserProperties();
}

