/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encryptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.SnotifySmimeKey;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import net.savignano.snotify.atlassian.mailer.encryptor.AMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeKeyStoreLoader;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASmimeMailEncryptor
extends AMailEncryptor<SnotifySmimeKey> {
    private static final Logger log = LoggerFactory.getLogger(ASmimeMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify at {0} using S/MIME encryption with {1}";
    private KeyStore keyStore;

    public ASmimeMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected SnotifySmimeKey getValidityKey(EKeyValidity validity, EncryptionKeySource keySource) {
        return new SnotifySmimeKey(validity, keySource);
    }

    @Override
    protected MimeMessage encrypt() throws IOException, MessagingException {
        MimeBodyPart encryptedBody;
        String usedEncryptionAlgorithm;
        log.debug("Encrypting email to \"{}\" with certificate: {}", (Object)this.getAddress(), (Object)((SnotifySmimeKey)this.getPublicKey()).getEncryptionKey());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMessage().writeTo((OutputStream)baos);
            log.trace("Original email:\n{}\n", (Object)baos.toString());
        }
        SnotifyMimeMessage copyMsg = new SnotifyMimeMessage(this.getMessage());
        copyMsg.getContent();
        SnotifyMimeMessage msg = new SnotifyMimeMessage(this.getSession());
        Enumeration copyHeaders = copyMsg.getAllHeaderLines();
        while (copyHeaders.hasMoreElements()) {
            msg.addHeaderLine((String)copyHeaders.nextElement());
        }
        try {
            OutputEncryptor encryptor;
            SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
            BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(((SnotifySmimeKey)this.getPublicKey()).getEncryptionKey()));
            gen.addRecipientInfoGenerator(infoGenerator);
            try {
                log.debug("Using AES256_CBC algorithm for encryption.");
                usedEncryptionAlgorithm = "AES256_CBC";
                encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build();
            }
            catch (CMSException e) {
                if (e.getMessage().contains("Illegal key size")) {
                    log.debug(e.getMessage(), (Throwable)e);
                    log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. AES256_CBC encryption standard can not be used. Using fallback AES128_CBC encryption algorithm.");
                    usedEncryptionAlgorithm = "AES128_CBC";
                    encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build();
                }
                throw e;
            }
            encryptedBody = gen.generate(copyMsg, encryptor);
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                encryptedBody.writeTo((OutputStream)baos);
                log.trace("Encrypted body:\n{}\n", (Object)baos.toString());
            }
        }
        catch (CertificateEncodingException | CMSException | SMIMEException e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        msg.setContent(encryptedBody.getContent(), encryptedBody.getContentType());
        msg.addHeader("X-Encrypted", this.getXencryptedMailValue(usedEncryptionAlgorithm));
        msg.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo(baos);
            log.trace("Final email:\n{}\n", (Object)baos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)this.getAddress());
        return msg;
    }

    @Override
    protected Collection<IKeyLoader<SnotifySmimeKey>> getKeyLoaders() {
        IKeyLoader<SnotifySmimeKey> keyStoreLoader;
        ArrayList<IKeyLoader<SnotifySmimeKey>> loaders = new ArrayList<IKeyLoader<SnotifySmimeKey>>();
        IKeyLoader<SnotifySmimeKey> ldapLoader = this.createLdapLoader();
        if (ldapLoader != null) {
            loaders.add(ldapLoader);
        }
        if ((keyStoreLoader = this.createKeyStoreLoader()) != null) {
            loaders.add(keyStoreLoader);
        }
        return loaders;
    }

    protected IKeyLoader<SnotifySmimeKey> createKeyStoreLoader() {
        if (this.getKeyStore() == null) {
            log.debug("No key store specified. Can't get certificate from key store.");
            return null;
        }
        return new SmimeKeyStoreLoader(this.getKeyStore(), this.getAddress().toString());
    }

    protected abstract IKeyLoader<SnotifySmimeKey> createLdapLoader();

    @Override
    protected SnotifySmimeKey getUserPublicKey() {
        byte[] cert = this.getUserProperties().getBytes("net.savignano.snotify.email.smime.cert", this.getUser());
        if (cert != null) {
            log.debug("Using certificate of user {} for encrypting email to \"{}\".", (Object)this.getUser(), (Object)this.getAddress());
            try {
                X509Certificate certificate = CertUtil.createCertificate(cert);
                SnotifySmimeKey key = new SnotifySmimeKey(certificate);
                key.setKeySource(EncryptionKeySource.USER);
                return key;
            }
            catch (CertificateException e) {
                log.error("Could not parse certificate stored for user: " + this.getUser(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR, EncryptionKeySource.USER);
            }
        }
        log.debug("User {} has no public certificate stored.", (Object)this.getUser());
        return this.getValidityKey(EKeyValidity.NOT_FOUND, EncryptionKeySource.USER);
    }

    @Override
    protected void storePublicKey(SnotifySmimeKey key) throws IOException {
        log.debug("Storing new S/MIME certificate to user properties: {}", (Object)key.getEncryptionKey());
        this.getUserProperties().setBytes("net.savignano.snotify.email.smime.cert", key.getEncoded(), this.getUser());
        this.getUserProperties().setLong("net.savignano.snotify.email.smime.timeStamp", System.currentTimeMillis(), this.getUser());
        this.getUserProperties().setEnum("net.savignano.snotify.email.smime.keySource", key.getKeySource(), this.getUser());
    }

    @Override
    protected AMailEncryptor.EncryptorData loadEncryptorData() {
        AMailEncryptor.EncryptorData data = new AMailEncryptor.EncryptorData();
        data.allowCustomUserKey = this.getAppProperties().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        data.expireTimeStamp = this.getAppProperties().getLong("net.savignano.snotify.mailer.expireKeys.timeStamp");
        data.keySource = this.getUserProperties().getEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.class, this.getUser());
        data.timeStamp = this.getUserProperties().getLong("net.savignano.snotify.email.smime.timeStamp", this.getUser());
        data.isLiteVersion = this.getAppProperties().getBoolean("net.savignano.snotify.lite.mode");
        return data;
    }

    protected String getXencryptedMailValue(String encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), encryptionAlgorithm);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    protected abstract ISnotifyAppProperties getAppProperties();

    protected abstract ISnotifyUserProperties getUserProperties();
}

