/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.SnotifySmimeKey;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeLdapLoader
implements IKeyLoader<SnotifySmimeKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeLdapLoader.class);
    private static final String BINARY_TRANSFER = "java.naming.ldap.attributes.binary";
    private static final String USER_SMIME_CERT = "userSMIMECertificate";
    private static final String USER_CERT = "userCertificate";
    private final LdapConnector connector;
    private String userName;
    private String email;
    private boolean searchCert = true;
    private boolean searchSmime = true;
    private boolean expectP7b;

    public SmimeLdapLoader(LdapConnector connector) {
        this(connector, null);
    }

    public SmimeLdapLoader(LdapConnector connector, String userName) {
        this.connector = connector;
        this.userName = userName;
        if (connector == null) {
            throw new IllegalArgumentException("LDAP connector must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnotifySmimeKey loadKey() {
        if (this.getUserName() == null) {
            log.warn("No user name given to look up S/MIME certificate for in LDAP.");
            return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
        }
        log.info("Looking up S/MIME certificate for user {} in LDAP.", (Object)this.getUserName());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(BINARY_TRANSFER, USER_SMIME_CERT);
        SnotifySmimeKey finalKey = new SnotifySmimeKey(EKeyValidity.NOT_FOUND, this.getKeySource());
        DirContext context = null;
        try {
            SnotifySmimeKey otherKey;
            log.debug("Connecting to LDAP server: {}", (Object)this.connector.getLdapUrl());
            this.connector.connect(env);
            context = this.connector.getContext();
            String attrName = this.connector.getUserNameKey() + "=" + this.getUserName() + "," + this.connector.getUserBase();
            log.debug("Used attribute name: {}", (Object)attrName);
            Attributes attributes = context.getAttributes(attrName, this.getFieldParameter());
            Attribute userSmimeCertAttr = null;
            Attribute userCertAttr = null;
            NamingEnumeration<String> ids = attributes.getIDs();
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                log.trace("Attribute ID: {}", (Object)id);
                if (id.startsWith(USER_CERT)) {
                    userCertAttr = attributes.get(id);
                    continue;
                }
                if (!id.startsWith(USER_SMIME_CERT)) continue;
                userSmimeCertAttr = attributes.get(id);
            }
            if (this.isSearchSmime()) {
                finalKey = this.getKeyFromUserSmimeCert(userSmimeCertAttr);
            }
            if (this.isSearchCert() && finalKey.getKeyValidity() != EKeyValidity.VALID && (otherKey = this.getKeyFromUserCert(userCertAttr)).getKeyValidity().ordinal() < finalKey.getKeyValidity().ordinal()) {
                finalKey = otherKey;
            }
        }
        catch (NamingException e) {
            log.warn("Error retrieving S/MIME certificate for user " + this.getUserName() + " in LDAP. Error message: " + e.getMessage(), (Throwable)e);
            SnotifySmimeKey snotifySmimeKey = new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
            return snotifySmimeKey;
        }
        finally {
            this.connector.disconnect();
        }
        log.info("S/MIME certificate for user {} in LDAP is: {}", (Object)this.getUserName(), (Object)finalKey.getKeyValidity());
        return finalKey;
    }

    private String[] getFieldParameter() {
        String[] stringArray;
        log.debug("Querying field {}: {}", (Object)USER_CERT, (Object)this.isSearchCert());
        log.debug("Querying field {}: {}", (Object)USER_SMIME_CERT, (Object)this.isSearchSmime());
        if (this.isSearchCert()) {
            String[] stringArray2;
            if (this.isSearchSmime()) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = USER_CERT;
                stringArray2 = stringArray3;
                stringArray3[1] = USER_SMIME_CERT;
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = USER_CERT;
            }
            return stringArray2;
        }
        if (this.isSearchSmime()) {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = USER_SMIME_CERT;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnotifySmimeKey getKeyFromUserSmimeCert(Attribute attribute) throws NamingException {
        InputStream is;
        if (attribute == null || attribute.get() == null) {
            log.debug("No data stored in {} attribute.", (Object)USER_SMIME_CERT);
            return new SnotifySmimeKey(EKeyValidity.NOT_FOUND, this.getKeySource());
        }
        log.debug("Retrieving data from {} attribute.", (Object)USER_SMIME_CERT);
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_SMIME_CERT, this.getUserName(), attribute.get().getClass().getName()});
            return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
        }
        if (this.isExpectP7b()) {
            log.debug("Expecting p7b format.");
            is = new ByteArrayInputStream(bytes);
        } else {
            log.debug("Expecting p7m format.");
            try {
                MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(bytes));
                is = msg.getInputStream();
            }
            catch (IOException | MessagingException e) {
                log.warn("Error loading S/MIME certificate for user " + this.getUserName() + " in LDAP. It appears that the stored content is not a properly formatted MIME message. Error message: " + e.getMessage(), e);
                return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
            }
        }
        log.debug("Email address to look for: {}", (Object)this.getEmail());
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(SecurityUtil.getProvider());
        try {
            CMSSignedData signature = new CMSSignedData(is);
            Store<X509CertificateHolder> certStore = signature.getCertificates();
            Collection<X509CertificateHolder> allHolders = certStore.getMatches(null);
            log.debug("Found {} certificate(s).", (Object)allHolders.size());
            if (allHolders.size() == 1) {
                X509Certificate certificate = converter.getCertificate(allHolders.iterator().next());
                log.trace("Used certificate: {}", (Object)certificate);
                SnotifySmimeKey key = new SnotifySmimeKey(certificate, this.getEmail());
                key.setKeySource(this.getKeySource());
                SnotifySmimeKey snotifySmimeKey = key;
                return snotifySmimeKey;
            }
            if (this.getEmail() != null) {
                for (X509CertificateHolder holder : allHolders) {
                    X509Certificate certificate = converter.getCertificate(holder);
                    log.trace("Found certificate: {}", (Object)certificate);
                    if (!CertUtil.isCertForEmail(certificate, this.getEmail())) continue;
                    log.debug("Using certificate with serial number: {}", (Object)certificate.getSerialNumber());
                    SnotifySmimeKey key = new SnotifySmimeKey(certificate, this.getEmail());
                    key.setKeySource(this.getKeySource());
                    SnotifySmimeKey snotifySmimeKey = key;
                    return snotifySmimeKey;
                }
            }
            log.debug("Found no certificate matching email: {}", (Object)this.getEmail());
            SnotifySmimeKey snotifySmimeKey = new SnotifySmimeKey(EKeyValidity.NOT_FOUND, this.getKeySource());
            return snotifySmimeKey;
        }
        catch (CertificateException | CMSException e) {
            log.warn("Error loading S/MIME certificate for user " + this.getUserName() + " in LDAP. It appears that the content is not a properly formatted p7 certificate or certificate chain. Error message: " + e.getMessage(), (Throwable)e);
            SnotifySmimeKey snotifySmimeKey = new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
            return snotifySmimeKey;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private SnotifySmimeKey getKeyFromUserCert(Attribute attribute) throws NamingException {
        if (attribute == null || attribute.get() == null) {
            log.debug("No data stored in {} attribute.", (Object)USER_CERT);
            return new SnotifySmimeKey(EKeyValidity.NOT_FOUND, this.getKeySource());
        }
        log.debug("Retrieving data from {} attribute.", (Object)USER_CERT);
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_CERT, this.getUserName(), attribute.get().getClass().getName()});
            return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
        }
        log.info("Found S/MIME certificate for user {} in LDAP.", (Object)this.getUserName());
        try {
            X509Certificate cert = CertUtil.createCertificate(bytes);
            log.trace("Found certificate: {}", (Object)cert);
            SnotifySmimeKey key = new SnotifySmimeKey(cert, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (CertificateException e) {
            log.warn("Error loading S/MIME certificate for user " + this.getUserName() + " in LDAP. Error message: " + e.getMessage(), (Throwable)e);
            return new SnotifySmimeKey(EKeyValidity.ERROR, this.getKeySource());
        }
    }

    private byte[] asBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes(Constants.UTF8_CHARSET);
        }
        return null;
    }

    @Override
    public EncryptionKeySource getKeySource() {
        return EncryptionKeySource.LDAP;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isSearchCert() {
        return this.searchCert;
    }

    public void setSearchCert(boolean searchCert) {
        this.searchCert = searchCert;
    }

    public boolean isSearchSmime() {
        return this.searchSmime;
    }

    public void setSearchSmime(boolean searchSmime) {
        this.searchSmime = searchSmime;
    }

    public boolean isExpectP7b() {
        return this.expectP7b;
    }

    public void setExpectP7b(boolean expectP7b) {
        this.expectP7b = expectP7b;
    }
}

