/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

public class RFC6637Utils {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("416E6F6E796D6F75732053656E64657220202020");

    private RFC6637Utils() {
    }

    public static String getAgreementAlgorithm(PublicKeyPacket pubKeyData) {
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        switch (ecKey.getHashAlgorithm()) {
            case 8: {
                return "ECCDHwithSHA256CKDF";
            }
            case 9: {
                return "ECCDHwithSHA384CKDF";
            }
            case 10: {
                return "ECCDHwithSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + ecKey.getHashAlgorithm());
    }

    public static ASN1ObjectIdentifier getKeyEncryptionOID(int algID) throws PGPException {
        switch (algID) {
            case 7: {
                return NISTObjectIdentifiers.id_aes128_wrap;
            }
            case 8: {
                return NISTObjectIdentifiers.id_aes192_wrap;
            }
            case 9: {
                return NISTObjectIdentifiers.id_aes256_wrap;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + algID);
    }

    public static byte[] createUserKeyingMaterial(PublicKeyPacket pubKeyData, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        ByteArrayOutputStream pOut = new ByteArrayOutputStream();
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        byte[] encOid = ecKey.getCurveOID().getEncoded();
        pOut.write(encOid, 1, encOid.length - 1);
        pOut.write(pubKeyData.getAlgorithm());
        pOut.write(3);
        pOut.write(1);
        pOut.write(ecKey.getHashAlgorithm());
        pOut.write(ecKey.getSymmetricKeyAlgorithm());
        pOut.write(ANONYMOUS_SENDER);
        pOut.write(fingerPrintCalculator.calculateFingerprint(pubKeyData));
        return pOut.toByteArray();
    }
}

