/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.xmss;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA512Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;

public class XMSSMTSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest digest;
    private XMSSMTSigner signer;
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random;

    protected XMSSMTSignatureSpi(String algorithm) {
        super(algorithm);
    }

    protected XMSSMTSignatureSpi(String sigName, Digest digest, XMSSMTSigner signer) {
        super(sigName);
        this.digest = digest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCXMSSMTPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSSMT");
        }
        CipherParameters param = ((BCXMSSMTPublicKey)publicKey).getKeyParams();
        this.treeDigest = null;
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters param;
        if (privateKey instanceof BCXMSSMTPrivateKey) {
            param = ((BCXMSSMTPrivateKey)privateKey).getKeyParams();
            this.treeDigest = ((BCXMSSMTPrivateKey)privateKey).getTreeDigestOID();
            if (this.random != null) {
                param = new ParametersWithRandom(param, this.random);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to XMSSMT");
        }
        this.digest.reset();
        this.signer.init(true, param);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw new SignatureException(e.getMessage());
            }
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        return this.signer.verifySignature(hash, sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public PrivateKey getUpdatedPrivateKey() {
        if (this.treeDigest == null) {
            throw new IllegalStateException("signature object not in a signing state");
        }
        BCXMSSMTPrivateKey rKey = new BCXMSSMTPrivateKey(this.treeDigest, (XMSSMTPrivateKeyParameters)this.signer.getUpdatedPrivateKey());
        this.treeDigest = null;
        return rKey;
    }

    public static class withShake256
    extends XMSSMTSignatureSpi {
        public withShake256() {
            super("SHAKE256withXMSSMT", new SHAKEDigest(256), new XMSSMTSigner());
        }
    }

    public static class withSha512
    extends XMSSMTSignatureSpi {
        public withSha512() {
            super("SHA512withXMSSMT", new SHA512Digest(), new XMSSMTSigner());
        }
    }

    public static class withShake128
    extends XMSSMTSignatureSpi {
        public withShake128() {
            super("SHAKE128withXMSSMT", new SHAKEDigest(128), new XMSSMTSigner());
        }
    }

    public static class withSha256
    extends XMSSMTSignatureSpi {
        public withSha256() {
            super("SHA256withXMSSMT", new SHA256Digest(), new XMSSMTSigner());
        }
    }
}

