/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MyJCE
extends Provider {
    private static final long serialVersionUID = -5786152406947817406L;
    private static final Logger log = LoggerFactory.getLogger(MyJCE.class);
    private static X509Certificate providerCert = null;

    public static final synchronized boolean selfIntegrityChecking() {
        log.debug("Starting 'Self Integrity Checking' of S/Notify.");
        URL providerURL = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                CodeSource cs = MyJCE.class.getProtectionDomain().getCodeSource();
                return cs.getLocation();
            }
        });
        log.debug("Provider URL for S/Notify Jar: {}", (Object)providerURL);
        if (providerURL == null) {
            return false;
        }
        JarVerifier jv = new JarVerifier(providerURL);
        try {
            if (providerCert == null) {
                providerCert = MyJCE.setupProviderCert();
            }
            jv.verify(providerCert);
        }
        catch (Exception e) {
            log.debug("Error during integrity checking. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        log.debug("'Self Integrity Checking' of S/Notify successful.");
        return true;
    }

    private static X509Certificate setupProviderCert() throws IOException, CertificateException {
        try (InputStream in = MyJCE.class.getResourceAsStream("/codesign-oracle-savignano-sw.pem");){
            X509Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(in);
            return x509Certificate;
        }
    }

    public MyJCE() {
        super("MyJCE", 1.0, "sample provider which supports nothing");
    }

    private static class JarVerifier {
        private URL jarURL = null;
        private JarFile jarFile = null;

        JarVerifier(URL jarURL) {
            this.jarURL = jarURL;
        }

        private JarFile retrieveJarFileFromURL(URL url) throws PrivilegedActionException, MalformedURLException {
            log.debug("Retrieving JAR file from URL: {}", (Object)url);
            JarFile jf = null;
            this.jarURL = url.getProtocol().equalsIgnoreCase("jar") ? url : new URL("jar:" + url.toString() + "!/");
            jf = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
                    conn.setUseCaches(false);
                    return conn.getJarFile();
                }
            });
            return jf;
        }

        public void verify(X509Certificate targetCert) throws IOException {
            if (targetCert == null) {
                throw new SecurityException("Provider certificate is not present.");
            }
            try {
                if (this.jarFile == null) {
                    this.jarFile = this.retrieveJarFileFromURL(this.jarURL);
                }
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException();
                se.initCause(ex);
                throw se;
            }
            Manifest man = this.jarFile.getManifest();
            log.debug("Manifest file present: {}", (Object)(man != null ? 1 : 0));
            if (man == null) {
                throw new SecurityException("The provider is not signed. Manifest file not found.");
            }
            ArrayList<JarEntry> verifyEntries = new ArrayList<JarEntry>();
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                verifyEntries.add(je);
                log.trace("Reading jar entry: {}", (Object)je);
                InputStream is = this.jarFile.getInputStream(je);
                Throwable throwable = null;
                try {
                    while (is.read(buffer, 0, buffer.length) != -1) {
                    }
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            for (JarEntry je : verifyEntries) {
                X509Certificate[] certChain;
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    log.trace("No signature found for: {}", (Object)je);
                    if (je.getName().startsWith("META-INF")) continue;
                    log.error("Jar entry was not signed: {}", (Object)je);
                    throw new SecurityException("The provider has unsigned class files.");
                }
                log.trace("Signature found for: {}", (Object)je);
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(targetCert)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                log.error("Jar entry was not signed with the expected signer: {}", (Object)je);
                throw new SecurityException("The provider is not signed with the expected signer.");
            }
        }

        private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }

        protected void finalize() throws Throwable {
            this.jarFile.close();
        }
    }
}

