/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.SnotifyPgpKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyServerLoader
implements IKeyLoader<SnotifyPgpKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpKeyServerLoader.class);
    private final String keyServer;
    private final String email;
    private boolean encodeSearchParam = true;
    private int timeout = 20000;

    public PgpKeyServerLoader(String keyServer, String email) {
        this.keyServer = keyServer;
        this.email = email;
        if (keyServer == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    public SnotifyPgpKey loadKey() {
        Set<String> keyIds;
        log.info("Looking up public key for email {} from: {}", (Object)this.getEmail(), (Object)this.keyServer);
        try {
            keyIds = this.getKeyIdsFromServer(this.keyServer, "<" + this.getEmail().toLowerCase(Locale.ROOT) + ">");
        }
        catch (IOException e) {
            log.warn("Error retrieving public key from key server for email: " + this.getEmail(), (Throwable)e);
            return new SnotifyPgpKey(EKeyValidity.ERROR, this.getKeySource());
        }
        if (keyIds.isEmpty()) {
            return new SnotifyPgpKey(EKeyValidity.NOT_FOUND, this.getKeySource());
        }
        List<SnotifyPgpKey> keys = this.getKeysFromServer(this.keyServer, keyIds);
        SnotifyPgpKey key = this.getNewestKey(keys);
        if (key.getKeyValidity() == EKeyValidity.VALID) {
            log.info("Found public key for email {} with ID: {}", (Object)this.getEmail(), (Object)PgpUtil.getPrettyId(key.getMasterKey()));
        } else {
            log.info("No public key found for email: {}", (Object)this.getEmail());
        }
        return key;
    }

    @Override
    public EncryptionKeySource getKeySource() {
        return EncryptionKeySource.KEYSERVER;
    }

    private SnotifyPgpKey getNewestKey(Collection<SnotifyPgpKey> keys) {
        EKeyValidity fallbackValidity = EKeyValidity.ERROR;
        long newestCreationTime = 0L;
        SnotifyPgpKey newestKey = null;
        for (SnotifyPgpKey key : keys) {
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                PGPPublicKey encKey = key.getEncryptionKey();
                if (encKey.getCreationTime().getTime() <= newestCreationTime) continue;
                newestCreationTime = encKey.getCreationTime().getTime();
                newestKey = key;
                continue;
            }
            fallbackValidity = key.getKeyValidity();
        }
        if (newestKey != null && log.isDebugEnabled()) {
            PGPPublicKey encKey = newestKey.getEncryptionKey();
            PGPPublicKey masterKey = newestKey.getMasterKey();
            String prettyEncKeyId = PgpUtil.getPrettyId(encKey);
            String prettyMasterKeyId = PgpUtil.getPrettyId(masterKey);
            log.debug("Most current key (ID: {}, Master Key ID: {}). Creation time: {}", new Object[]{prettyEncKeyId, prettyMasterKeyId, encKey.getCreationTime()});
        } else if (newestKey == null) {
            log.debug("Could not find a valid key. Most likely explanation: {}", (Object)fallbackValidity);
            newestKey = new SnotifyPgpKey(fallbackValidity, this.getKeySource());
        }
        return newestKey;
    }

    private List<SnotifyPgpKey> getKeysFromServer(String baseUrl, Collection<String> keyIds) {
        ArrayList<SnotifyPgpKey> keys = new ArrayList<SnotifyPgpKey>(keyIds.size());
        for (String keyId : keyIds) {
            PGPPublicKeyRingCollection key = this.getKeyFromServer(baseUrl, keyId);
            if (key == null) continue;
            SnotifyPgpKey pgpKey = new SnotifyPgpKey(key, this.getEmail());
            pgpKey.setKeySource(this.getKeySource());
            keys.add(pgpKey);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyIdsFromServer(String baseUrl, String searchFor) throws IOException {
        HashSet<String> keyIds = new HashSet<String>();
        URL url = this.createUrl(baseUrl, searchFor, "index", this.isEncodeSearchParam());
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(url);
            log.debug("Connecting to: {}", (Object)connection.getURL());
            connection.connect();
            if (connection.getResponseCode() == 404) {
                log.debug("No public key found (response code 404) for: {}", (Object)searchFor);
                HashSet<String> hashSet = keyIds;
                return hashSet;
            }
            try (InputStream is = connection.getInputStream();){
                long currentTime = System.currentTimeMillis() / 1000L;
                String keyId = null;
                boolean skipToNextKey = false;
                String encoding = connection.getContentEncoding();
                LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
                while (lineIterator.hasNext()) {
                    String[] parts;
                    String line = URLDecoder.decode(lineIterator.nextLine(), "UTF-8").toLowerCase(Locale.ROOT);
                    log.trace(line);
                    if (line.startsWith("pub:")) {
                        skipToNextKey = true;
                        keyId = null;
                        parts = line.split(":", 7);
                        if (parts.length != 7) continue;
                        keyId = parts[1];
                        String expirationDate = parts[5];
                        String flags = parts[6];
                        boolean validKey = flags.isEmpty() || expirationDate.isEmpty() || Long.parseLong(expirationDate) > currentTime;
                        skipToNextKey = !validKey;
                        continue;
                    }
                    if (skipToNextKey || !line.startsWith("uid:") || (parts = line.split(":", 5)).length != 5 || !parts[1].contains(searchFor)) continue;
                    log.info("Found matching public key for {} with ID: {}", (Object)searchFor, (Object)keyId);
                    keyIds.add(keyId);
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (keyIds.isEmpty()) {
            log.debug("No public key found for: {}", (Object)searchFor);
        } else {
            log.debug("Key IDs found for {}: {}", (Object)searchFor, keyIds);
        }
        return keyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PGPPublicKeyRingCollection getKeyFromServer(String baseUrl, String keyId) {
        log.debug("Looking up pulic key with ID: " + keyId);
        HttpURLConnection connection = null;
        try {
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection;
            Throwable throwable;
            InputStream is;
            block22: {
                block23: {
                    URL url = this.createUrl(baseUrl, "0x" + keyId, "get", false);
                    connection = this.createConnection(url);
                    log.debug("Connecting to: {}", (Object)connection.getURL());
                    connection.connect();
                    if (connection.getResponseCode() == 404) {
                        log.debug("No public key found with ID: {}", (Object)keyId);
                        PGPPublicKeyRingCollection pGPPublicKeyRingCollection2 = null;
                        return pGPPublicKeyRingCollection2;
                    }
                    is = connection.getInputStream();
                    throwable = null;
                    pGPPublicKeyRingCollection = PgpUtil.getPublicCollection(IOUtils.toByteArray((InputStream)is));
                    if (is == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                is.close();
            }
            return pGPPublicKeyRingCollection;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (PGPException e) {
                        log.warn("Error reading public key with ID " + keyId + " from keyserver for email: " + this.getEmail(), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    log.warn("Error retrieving public key with ID " + keyId + " from keyserver for email: " + this.getEmail(), (Throwable)e);
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    protected URL createUrl(String baseUrl, String searchFor, String operation, boolean encode) throws UnsupportedEncodingException, MalformedURLException {
        String basePath = "pks/lookup";
        String searchArg = "search";
        String operationArg = "op";
        String options = "options=mr";
        String exact = "exact=on";
        StringBuilder builder = new StringBuilder(1000);
        boolean hkpFound = baseUrl.startsWith("hkp");
        if (hkpFound) {
            hkpFound = true;
            builder.append("http");
            builder.append(baseUrl.substring(3));
        } else {
            builder.append(baseUrl);
        }
        if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append("pks/lookup");
        builder.append('?');
        builder.append("options=mr");
        builder.append('&');
        builder.append("exact=on");
        builder.append('&');
        builder.append("op");
        builder.append('=');
        builder.append(operation);
        builder.append('&');
        builder.append("search");
        builder.append('=');
        builder.append(encode ? URLEncoder.encode(searchFor, "UTF-8") : searchFor);
        URL url = new URL(builder.toString());
        if (hkpFound && url.getPort() == -1) {
            int port = url.getProtocol().equals("http") ? 11371 : 443;
            return new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        }
        return url;
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(false);
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        return connection;
    }

    public String getKeyServerUrl() {
        return this.keyServer;
    }

    public String getEmail() {
        return this.email;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isEncodeSearchParam() {
        return this.encodeSearchParam;
    }

    public void setEncodeSearchParam(boolean encodeSearchParam) {
        this.encodeSearchParam = encodeSearchParam;
    }

    public String toString() {
        return "Key Server: " + this.keyServer;
    }
}

