/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.mailer.encryptor.APgpMailEncryptor;
import net.savignano.snotify.confluence.mailer.ConfluenceUser;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailEncryptor
extends APgpMailEncryptor {
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify for Confluence at {0} using PGP encryption with {1}";
    private static final Logger log = LoggerFactory.getLogger(PgpMailEncryptor.class);

    private static final ConfluenceUser getUserForAddress(Address address) {
        String email = address.toString();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        SearchResult searchResult = userAccessor.getUsersByEmail(email);
        Iterator users = searchResult.pager().iterator();
        if (users.hasNext()) {
            User user = (User)users.next();
            log.debug("Found user {} for email \"{}\".", (Object)user, (Object)email);
            if (users.hasNext()) {
                ArrayList<Object> logUsers = new ArrayList<Object>();
                logUsers.add(user);
                while (users.hasNext()) {
                    logUsers.add(users.next());
                }
                log.warn("Multiple users found for email \"{}\". First user found used for encryption purposes, but this can be unpredictable: {}", (Object)email, logUsers);
            }
            return new ConfluenceUser(user);
        }
        log.error("No user found for email: {}", (Object)email);
        return null;
    }

    public PgpMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected String getXencryptedMailValue(String encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), encryptionAlgorithm);
    }

    @Override
    public ConfluenceUser getUser() {
        return (ConfluenceUser)super.getUser();
    }

    @Override
    protected ConfluenceUser loadUser() {
        return PgpMailEncryptor.getUserForAddress(this.getAddress());
    }

    @Override
    protected ISnotifyAppProperties getAppProperties() {
        return PropertiesUtil.getAppProps();
    }

    @Override
    protected ISnotifyUserProperties getUserProperties() {
        return PropertiesUtil.getUserProps();
    }
}

