/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.secret;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmimeSignKey
extends ASnotifyKey<PrivateKey>
implements ISnotifySecretKey<PrivateKey> {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmimeSignKey.class);
    private PrivateKey privateKey;
    private X509Certificate publicCert;
    private final List<X509Certificate> intermediateCerts = new ArrayList<X509Certificate>();

    public SnotifySmimeSignKey(PrivateKey privateKey, X509Certificate publicCert) {
        super(EKeyPurpose.SIGNING);
        this.privateKey = privateKey;
        this.publicCert = publicCert;
        if (privateKey == null) {
            log.warn("Private key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (publicCert == null) {
            log.warn("Public certificate was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (!SmimeUtil.isCertForPurpose(publicCert, this.getKeyPurpose())) {
            log.debug("Certificate can not be used for purpose: {}", (Object)this.getKeyPurpose());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifySmimeSignKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifySmimeSignKey(EKeyValidity validity, EKeySource source) {
        super(EKeyPurpose.SIGNING);
        this.setKeyValidity(validity);
        this.setKeySource(source);
    }

    @Override
    public PrivateKey getKey() {
        return this.privateKey;
    }

    public X509Certificate getPublicCert() {
        return this.publicCert;
    }

    public List<X509Certificate> getIntermediateCerts() {
        return this.intermediateCerts;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.privateKey = null;
        this.publicCert = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.privateKey == null && this.publicCert == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Sign Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Private Key: ");
        builder.append(this.privateKey);
        builder.append("; Public Certificate: ");
        builder.append(this.publicCert);
        builder.append("; Intermediate Certificates: ");
        builder.append(this.intermediateCerts);
        return builder.toString();
    }
}

