/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.update;

import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.update.SnotifyUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyAtlassianUpdateManager
extends SnotifyUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyAtlassianUpdateManager.class);

    @Override
    protected void initialize() {
        super.initialize();
        this.getAppProps();
        this.add("3.1.0", this::updatePublicSmimeKeystoreType);
        this.add("3.1.0", this::addNoProjectEncryptionState);
    }

    private void updatePublicSmimeKeystoreType() {
        log.debug("Evaluating update of public S/MIME key store.");
        if (this.getAppProps().hasKey(EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION)) {
            log.debug("Added information about public S/MIME key store. Type: Bouncy Castle Key Store");
            this.getAppProps().setString(EProperty.PUBLIC_KEYSTORE_SMIME_TYPE, "BKS");
        } else {
            log.debug("No public S/MIME key store configured.");
        }
    }

    private void addNoProjectEncryptionState() {
        log.debug("Evaluating adding of 'no project encryption state'.");
        if (this.getAppProps().hasKey(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE)) {
            boolean ambiguous = this.getAppProps().getBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE);
            log.debug("Added 'no project encryption state'. New value: {}", (Object)ambiguous);
            this.getAppProps().setBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE, ambiguous);
        } else {
            log.debug("'No project encryption state' not added.");
        }
    }

    public abstract ISnotifyAppProperties getAppProps();
}

