/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);

    public static final Optional<Address> getFrom(MimeMessage msg) {
        Address[] addresses;
        String msgId = MessageUtil.getMessageId(msg);
        try {
            addresses = msg.getFrom();
        }
        catch (MessagingException e) {
            log.error("Could not get 'from' address for message " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return MessageUtil.getAddress(addresses, msgId);
    }

    public static final Optional<String> getFromEmail(MimeMessage msg) {
        Optional<Address> address = MessageUtil.getFrom(msg);
        return Optional.ofNullable(address.isPresent() ? MessageUtil.getEmail(address.get()) : null);
    }

    public static final Optional<Address> getTo(MimeMessage msg) {
        Address[] addresses;
        String msgId = MessageUtil.getMessageId(msg);
        try {
            addresses = msg.getRecipients(Message.RecipientType.TO);
        }
        catch (MessagingException e) {
            log.error("Could not get 'to' address for message " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return MessageUtil.getAddress(addresses, MessageUtil.getMessageId(msg));
    }

    public static final Optional<String> getToEmail(MimeMessage msg) {
        Optional<Address> address = MessageUtil.getTo(msg);
        return Optional.ofNullable(address.isPresent() ? MessageUtil.getEmail(address.get()) : null);
    }

    public static final String getEmail(Address address) {
        if (address == null) {
            return null;
        }
        String email = address instanceof InternetAddress ? ((InternetAddress)address).getAddress() : address.toString();
        log.debug("Email for address {}: {}", (Object)address, (Object)email);
        return email;
    }

    private static final Optional<Address> getAddress(Address[] addresses, String msgId) {
        if (addresses == null || addresses.length == 0 || addresses[0] == null) {
            log.warn("No addresses found in message {}.", (Object)msgId);
            return Optional.empty();
        }
        if (addresses.length > 1) {
            log.warn("Multiple email addresses found in message {}, when only one was expected. Using first address. Found addresses: {}", (Object)msgId, (Object)Arrays.toString(addresses));
        }
        return Optional.ofNullable(addresses[0]);
    }

    public static final String getMessageId(MimeMessage msg) {
        if (msg == null) {
            return null;
        }
        try {
            return msg.getMessageID();
        }
        catch (MessagingException e) {
            log.error("Could not get message ID for message with serial number " + msg.getMessageNumber() + ". Error message: " + e.getMessage(), (Throwable)e);
            return "!" + msg.getMessageNumber() + "!";
        }
    }

    public static final void copyAllHeaders(Part from, Part to) throws MessagingException {
        Enumeration allHeaders = from.getAllHeaders();
        while (allHeaders.hasMoreElements()) {
            Header header = (Header)allHeaders.nextElement();
            to.setHeader(header.getName(), header.getValue());
        }
    }

    public static final void copyMatchingHeaders(Part from, Part to, String ... headers) throws MessagingException {
        Enumeration matchingHeaders = from.getMatchingHeaders(headers);
        while (matchingHeaders.hasMoreElements()) {
            Header header = (Header)matchingHeaders.nextElement();
            to.setHeader(header.getName(), header.getValue());
        }
    }

    public static final void copyNonMatchingHeaders(Part from, Part to, String ... headers) throws MessagingException {
        Enumeration nonMatchingHeaders = from.getNonMatchingHeaders(headers);
        while (nonMatchingHeaders.hasMoreElements()) {
            Header header = (Header)nonMatchingHeaders.nextElement();
            to.setHeader(header.getName(), header.getValue());
        }
    }
}

