/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(AAtlassianMailKeyExtractor.class);
    private final String baseUrl;
    private final Pattern baseUrlPattern;

    public AAtlassianMailKeyExtractor(String baseUrl) {
        log.debug("Base URL used: " + baseUrl);
        this.baseUrl = baseUrl;
        this.baseUrlPattern = Pattern.compile("(?:^|[\"\\s])(" + baseUrl + "[^\"\\s]+)");
    }

    public Set<String> getKeys(MimeMessage msg) throws IOException, MessagingException {
        final HashSet<String> keys = new HashSet<String>();
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                log.trace("MimeType: {}", (Object)part.getContentType());
                if (part.isMimeType("text/*")) {
                    log.debug("Found text content. Content transfer encoding: {}", (Object)part.getHeader("Content-Transfer-Encoding", null));
                    Object content = part.getContent();
                    if (content instanceof String) {
                        keys.addAll(AAtlassianMailKeyExtractor.this.getProjectKeys((String)content));
                    } else {
                        log.warn("Expected content of type string, but was: {}", content == null ? null : content.getClass());
                    }
                }
                super.visit(part);
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException("Could not parse email. Error message: " + e.getMessage(), e);
        }
        return keys;
    }

    public Set<String> getProjectKeys(String str) {
        Matcher matcher = this.baseUrlPattern.matcher(str);
        Set<URL> matches = this.extractMatches(matcher);
        return this.getKeys(matches);
    }

    protected abstract String getKey(URL var1);

    private Set<URL> extractMatches(Matcher matcher) {
        HashSet<URL> matches = new HashSet<URL>();
        while (matcher.find()) {
            log.debug("Found match in email: {}", (Object)matcher.group());
            String url = StringEscapeUtils.unescapeHtml((String)matcher.group(1));
            log.debug("HTML escaped URL: {}", (Object)url);
            try {
                matches.add(new URL(url));
            }
            catch (MalformedURLException e) {
                log.error("Match " + url + " is not an URL. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return matches;
    }

    private Set<String> getKeys(Collection<URL> matches) {
        HashSet<String> projectKeys = new HashSet<String>();
        log.debug("Checking {} URLs.", (Object)matches.size());
        for (URL match : matches) {
            log.debug("Checking URL: {}", (Object)match);
            String projectKey = this.getKey(match);
            log.debug("Found key: {}", (Object)projectKey);
            if (projectKey == null) continue;
            projectKeys.add(projectKey);
        }
        log.debug("Found the following keys: {}", projectKeys);
        return projectKeys;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

