/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.AMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpSignKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeSignKeyManager;
import net.savignano.snotify.atlassian.mailer.protect.IMailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.protect.LegacyMailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.protect.Rfc822MailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.sign.PgpMailSigner;
import net.savignano.snotify.atlassian.mailer.sign.SmimeMailSigner;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAtlassianMailer<T extends IUser<?>>
extends AMailer {
    private static final Logger log = LoggerFactory.getLogger(AAtlassianMailer.class);
    private final ISnotifyAppProperties appProps;
    private final ISnotifyUserProperties userProps;
    private final ISnotifyProjectProperties projectProps;
    private boolean cachedEncryptionDesired;
    private MimeMessage lastCheckedMessage;
    private Pattern skipEncryptionPattern;
    private Boolean signingEnabled;
    private Boolean projectSpecificEncryption;
    private Boolean defaultProjectEncryption;
    private Boolean ambiguousProjectEncryption;
    private Boolean noProjectEncryption;
    private final Map<Address, T> address2UserMap = new HashMap<Address, T>();
    private String fromEmail;
    private SmimeMailSigner smimeSigner;
    private PgpMailSigner pgpSigner;

    public AAtlassianMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties projectProps) {
        super(session);
        this.appProps = appProps;
        this.userProps = userProps;
        this.projectProps = projectProps;
        if (appProps == null) {
            throw new IllegalArgumentException("Application Properties must not be null.");
        }
        if (userProps == null) {
            throw new IllegalArgumentException("User Properties must not be null.");
        }
        if (projectProps == null) {
            throw new IllegalArgumentException("Project Properties must not be null.");
        }
        appProps.setString(EProperty.MAILER_VERSION, this.getVersion());
    }

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        if (this.lastCheckedMessage == msgAndAddress.message) {
            return this.cachedEncryptionDesired;
        }
        this.lastCheckedMessage = msgAndAddress.message;
        this.cachedEncryptionDesired = this.isEncryptionDesiredBySkipRegex(this.lastCheckedMessage) && this.isEncryptionDesiredByProject(this.lastCheckedMessage);
        return this.cachedEncryptionDesired;
    }

    private boolean isEncryptionDesiredBySkipRegex(MimeMessage msg) {
        if (this.getSkipEncryptionPattern() == null) {
            return true;
        }
        StringWriter writer = new StringWriter();
        try (WriterOutputStream os = new WriterOutputStream((Writer)writer, Constants.UTF8_CHARSET);){
            msg.writeTo((OutputStream)os);
        }
        catch (Exception e) {
            log.error("Could not serialize message. Error message: " + e.getMessage(), (Throwable)e);
            return true;
        }
        log.debug("Checking whether email should be encrypted with pattern: {}", (Object)this.getSkipEncryptionPattern().pattern());
        Matcher matcher = this.getSkipEncryptionPattern().matcher(writer.toString());
        if (matcher.find()) {
            log.info("Email will not get encrypted, because of regex matching.");
            log.debug("Found match: {}", (Object)matcher.group());
            return false;
        }
        log.debug("No match found in email.");
        return true;
    }

    private boolean isEncryptionDesiredByProject(MimeMessage msg) {
        if (!this.isProjectSpecificEncryption()) {
            return true;
        }
        List<String> projectKeys = this.extractProjectKeys(msg);
        log.debug("Checking encryption state for project(s): {}", projectKeys);
        switch (projectKeys.size()) {
            case 0: {
                return this.isNoProjectEncryption();
            }
            case 1: {
                String projectKey = projectKeys.get(0);
                return this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey);
            }
        }
        String projectKey = projectKeys.get(0);
        boolean encryptionDesired = this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey);
        for (int i = 1; i < projectKeys.size(); ++i) {
            projectKey = projectKeys.get(i);
            if (encryptionDesired == this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey)) continue;
            log.debug("Projects have different encryption settings.");
            encryptionDesired = this.isAmbiguousProjectEncryption();
            break;
        }
        return encryptionDesired;
    }

    @Override
    protected boolean isSigningDesired(MessageAndAddress msgAndAddress) {
        if (!super.isSigningDesired(msgAndAddress)) {
            return false;
        }
        return this.isSigningEnabled();
    }

    protected SmimeMailSigner getSmimeSigner(Address address) {
        String email = MessageUtil.getEmail(address);
        if (!StringUtils.equals((String)email, (String)this.fromEmail)) {
            this.smimeSigner = null;
            this.pgpSigner = null;
            this.fromEmail = email;
        }
        if (this.smimeSigner == null) {
            log.debug("Loading S/MIME mail signer for: {}", (Object)email);
            this.smimeSigner = this.getSmimeMailSigner(email);
        }
        return this.smimeSigner;
    }

    private SmimeMailSigner getSmimeMailSigner(String email) {
        SnotifySmimeSignKey key = (SnotifySmimeSignKey)new SmimeSignKeyManager(email, this.getAppProps()).getKey();
        return new SmimeMailSigner(this.getSession(), key);
    }

    protected PgpMailSigner getPgpSigner(Address address) {
        String email = MessageUtil.getEmail(address);
        if (!StringUtils.equals((String)email, (String)this.fromEmail)) {
            this.smimeSigner = null;
            this.pgpSigner = null;
            this.fromEmail = email;
        }
        if (this.pgpSigner == null) {
            log.debug("Loading PGP mail signer for: {}", (Object)email);
            this.pgpSigner = this.getPgpMailSigner(email);
        }
        return this.pgpSigner;
    }

    private PgpMailSigner getPgpMailSigner(String email) {
        SnotifyPgpSignKey key = (SnotifyPgpSignKey)new PgpSignKeyManager(email, this.getAppProps()).getKey();
        return new PgpMailSigner(this.getSession(), key);
    }

    @Override
    protected IMailHeaderProtector getMailHeaderProtector(ECryptographyType cryptography) {
        if (!this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION)) {
            return null;
        }
        String protectionType = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_METHOD);
        log.debug("Type of mail header protector to get for {}: {}", (Object)cryptography, (Object)protectionType);
        if (cryptography == null || protectionType == null) {
            log.warn("No cryptography or protection method given. Can not protect headers.");
            return null;
        }
        switch (protectionType) {
            case "protected-headers-v1": {
                switch (cryptography) {
                    case SMIME: 
                    case PGP: {
                        return new LegacyMailHeaderProtector();
                    }
                }
                return null;
            }
            case "message/rfc822": {
                switch (cryptography) {
                    case SMIME: 
                    case PGP: {
                        return new Rfc822MailHeaderProtector();
                    }
                }
                return null;
            }
        }
        log.warn("Unknown subject protection method specified. Email headers will not be protected. Valid methods: \"protected-headers-v1\", \"message/rfc822\"");
        return null;
    }

    protected abstract List<String> extractProjectKeys(MimeMessage var1);

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    public ISnotifyProjectProperties getProjectProps() {
        return this.projectProps;
    }

    public T getUser(Address address) {
        if (address == null) {
            return null;
        }
        IUser user = (IUser)this.address2UserMap.get(address);
        if (user == null && !this.address2UserMap.containsKey(address)) {
            user = this.loadUser(address);
            this.address2UserMap.put(address, user);
        }
        return (T)user;
    }

    protected abstract T loadUser(Address var1);

    public Pattern getSkipEncryptionPattern() {
        if (this.skipEncryptionPattern == null) {
            this.skipEncryptionPattern = this.loadSkipEncryptionPattern();
        }
        return this.skipEncryptionPattern;
    }

    protected Pattern loadSkipEncryptionPattern() {
        String skipEncRegex = this.getAppProps().getString(EProperty.TWEAK_SKIP_ENCRYPTION_REGEX);
        if (skipEncRegex != null) {
            try {
                return Pattern.compile(skipEncRegex, 8);
            }
            catch (PatternSyntaxException e) {
                log.error("Regex pattern \"" + skipEncRegex + "\" for skipping email encryption is not a valid regex. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isProjectSpecificEncryption() {
        if (this.projectSpecificEncryption == null) {
            this.projectSpecificEncryption = this.loadProjectSpecificEncryption();
        }
        return this.projectSpecificEncryption;
    }

    protected boolean loadProjectSpecificEncryption() {
        return this.getAppProps().getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
    }

    public boolean isDefaultProjectEncryption() {
        if (this.defaultProjectEncryption == null) {
            this.defaultProjectEncryption = this.loadDefaultProjectEncryption();
        }
        return this.defaultProjectEncryption;
    }

    protected boolean loadDefaultProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isAmbiguousProjectEncryption() {
        if (this.ambiguousProjectEncryption == null) {
            this.ambiguousProjectEncryption = this.loadAmbiguousProjectEncryption();
        }
        return this.ambiguousProjectEncryption;
    }

    protected boolean loadAmbiguousProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isNoProjectEncryption() {
        if (this.noProjectEncryption == null) {
            this.noProjectEncryption = this.loadNoProjectEncryption();
        }
        return this.noProjectEncryption;
    }

    protected boolean loadNoProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isSigningEnabled() {
        if (this.signingEnabled == null) {
            this.signingEnabled = this.loadSigningEnabled();
        }
        return this.signingEnabled;
    }

    protected boolean loadSigningEnabled() {
        return this.getAppProps().getBoolean(EProperty.SIGNING_ENABLED);
    }

    @Override
    protected boolean loadAdditionalSigningPgp() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_PGP_ADDITIONAL_SIGN);
    }

    @Override
    protected boolean loadAdditionalSigningSmime() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_ADDITIONAL_SIGN);
    }

    @Override
    protected boolean loadDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    protected boolean loadFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    @Override
    protected boolean loadLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    @Override
    protected boolean loadDryRun() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_DRY_RUN_MAILER);
    }

    @Override
    protected EEncryptionFailureBehavior loadFailureBehavior() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_FAILURE_BEHAVIOR, EEncryptionFailureBehavior.class);
    }

    @Override
    protected EEncryptionTypePriority loadTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    @Override
    protected String loadSubjectReplacement() {
        String replacement = null;
        if (this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION)) {
            String method = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_METHOD);
            replacement = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT);
            if (replacement == null && method != null) {
                switch (method) {
                    case "protected-headers-v1": {
                        replacement = "...";
                        break;
                    }
                    case "message/rfc822": {
                        replacement = "(hidden)";
                        break;
                    }
                    default: {
                        log.warn("Unknown subject protection method specified. Email subject will not be protected. Valid methods: \"protected-headers-v1\", \"message/rfc822\"");
                    }
                }
            }
        }
        return replacement;
    }
}

