/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.decrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpDecryptionKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.decrypt.AMailDecryptor;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailDecryptor
extends AMailDecryptor<SnotifyPgpDecryptionKey> {
    private static final String CONTENT_TYPE_ENCRYPTED = "multipart/encrypted";
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART1 = "application/pgp-encrypted";
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART2 = "application/octet-stream";
    private static final Logger log = LoggerFactory.getLogger(PgpMailDecryptor.class);

    public PgpMailDecryptor(Session session, SnotifyPgpDecryptionKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void decrypt(MimeMessage msg) throws IOException, MessagingException {
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimeMultipart multi) throws Exception {
                if (PgpMailDecryptor.this.isPgpEncrypted((Multipart)multi)) {
                    PgpMailDecryptor.this.decryptMultipart(multi.getParent(), (Multipart)multi);
                    this.setChanged(true);
                } else {
                    super.visit(multi);
                }
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (IOException | MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
    }

    private boolean isPgpEncrypted(Multipart multipart) throws MessagingException {
        if (multipart.getCount() != 2) {
            return false;
        }
        String contentType = multipart.getContentType();
        if (contentType == null || !contentType.startsWith(CONTENT_TYPE_ENCRYPTED)) {
            return false;
        }
        if (!multipart.getBodyPart(0).isMimeType(CONTENT_TYPE_PGP_ENCRYPTED_PART1)) {
            return false;
        }
        return multipart.getBodyPart(1).isMimeType(CONTENT_TYPE_PGP_ENCRYPTED_PART2);
    }

    private void decryptMultipart(Part parentPart, Multipart contentPart) throws MessagingException, IOException {
        byte[] decrypted;
        BodyPart part = contentPart.getBodyPart(1);
        try (InputStream is = part.getInputStream();){
            try {
                decrypted = PgpUtil.decrypt(is, ((SnotifyPgpDecryptionKey)this.getPrivateKey()).getKey(), ((SnotifyPgpDecryptionKey)this.getPrivateKey()).getPassword(), true);
            }
            catch (PGPException e) {
                if ("checksum mismatch at 0 of 20".equals(e.getMessage())) {
                    throw new MessagingException("Supplied password was wrong to extract private key.", (Exception)e);
                }
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        MimeMessage message = new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(decrypted));
        parentPart.setDisposition(null);
        parentPart.setContent(message.getContent(), message.getContentType());
        MessageUtil.copyNonMatchingHeaders((Part)message, parentPart, Constants.STRUCTURAL_MIME_HEADERS);
    }
}

