/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.decrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeDecryptionKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.decrypt.AMailDecryptor;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.Recipient;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnveloped;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailDecryptor
extends AMailDecryptor<SnotifySmimeDecryptionKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailDecryptor.class);

    public SmimeMailDecryptor(Session session, SnotifySmimeDecryptionKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void decrypt(MimeMessage msg) throws IOException, MessagingException {
        try {
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
            }
            if (!SmimeUtil.isMessageEncrypted((Message)msg)) {
                log.debug("Message is not S/MIME encrypted. Content type encountered: {}", (Object)msg.getContentType());
                return;
            }
            String msgId = MessageUtil.getMessageId(msg);
            Optional<String> recipientAddress = MessageUtil.getToEmail(msg);
            if (!recipientAddress.isPresent()) {
                throw new MessagingException("Could not determine recipient email address. Probably To-field not present in Email with ID " + msgId + ".");
            }
            String email = recipientAddress.get();
            KeyStore keyStore = ((SnotifySmimeDecryptionKey)this.getPrivateKey()).getKey();
            List<String> aliases = SmimeUtil.getAliasesForEmail(keyStore, email, EKeyPurpose.DECRYPTION);
            if (aliases.isEmpty()) {
                throw new MessagingException("Could not find any certificates in key store to decrypt emails for email address: " + email);
            }
            SMIMEEnveloped enveloped = new SMIMEEnveloped(msg);
            RecipientInformationStore recipientInfos = enveloped.getRecipientInfos();
            RecipientInformation recipientInfo = null;
            JceKeyTransEnvelopedRecipient recipient = null;
            for (String alias : aliases) {
                log.debug("Checking alias: {}", (Object)alias);
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                if (certificate == null) {
                    log.debug("No certificate found for alias {}.", (Object)alias);
                    continue;
                }
                JceKeyTransRecipientId recipientId = new JceKeyTransRecipientId(certificate);
                recipientInfo = recipientInfos.get(recipientId);
                if (recipientInfo == null) continue;
                log.info("Using certificate with serial number {} to decrypt email.", (Object)SmimeUtil.getSerialNumber(certificate));
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, ((SnotifySmimeDecryptionKey)this.getPrivateKey()).getPassword());
                if (privateKey == null) {
                    throw new MessagingException("Private key for alias " + alias + " not found in Key Store.");
                }
                recipient = new JceKeyTransEnvelopedRecipient(privateKey);
                break;
            }
            if (recipient == null) {
                String serialNumbers = null;
                for (RecipientInformation info : recipientInfos.getRecipients()) {
                    RecipientId id = info.getRID();
                    log.debug("Recipient Type encountered: {}", (Object)this.getRecipientType(id));
                    if (id.getType() != 0 || !(id instanceof KeyTransRecipientId)) continue;
                    String serialNumber = ((KeyTransRecipientId)id).getSerialNumber().toString(16).toUpperCase(Locale.ROOT);
                    log.debug("Serial number: {}", (Object)serialNumber);
                    if (serialNumbers == null) {
                        serialNumbers = serialNumber;
                        continue;
                    }
                    serialNumbers = serialNumbers + ", " + serialNumber;
                }
                if (serialNumbers == null) {
                    serialNumbers = "<N/A>";
                }
                throw new MessagingException("Found no Certificate in Key Store to decrypt Email with ID " + msgId + ". Certificate(s) used to encrypt email have serial number(s): " + serialNumbers);
            }
            this.decrypt(msg, recipientInfo, recipient);
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
            }
        }
        catch (Exception e) {
            throw new MessagingException("Could not decrypt email. Failure message: " + e.getMessage(), e);
        }
    }

    private void decrypt(MimeMessage msg, RecipientInformation recipientInfo, Recipient recipient) throws SMIMEException, CMSException, MessagingException, IOException {
        log.debug("Decrypting content.");
        MimeBodyPart decryptedPart = SMIMEUtil.toMimeBodyPart(recipientInfo.getContent(recipient));
        msg.setDisposition(null);
        msg.removeHeader("Content-Transfer-Encoding");
        ByteArrayDataSource ds = new ByteArrayDataSource(decryptedPart.getInputStream(), decryptedPart.getContentType());
        msg.setDataHandler(new DataHandler((DataSource)ds));
        MessageUtil.copyAllHeaders((Part)decryptedPart, (Part)msg);
        msg.saveChanges();
    }

    private String getRecipientType(RecipientId id) {
        switch (id.getType()) {
            case 0: {
                return "KeyTrans";
            }
            case 1: {
                return "Kek";
            }
            case 2: {
                return "KeyAgree";
            }
            case 3: {
                return "Password";
            }
        }
        return "<N/A>";
    }
}

