/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.encrypt.AMailEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailEncryptor
extends AMailEncryptor<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by {0} at {1} using PGP encryption with {2}";
    private int forceSymmetricKeyAlgorithm = -1;

    public PgpMailEncryptor(Session session, SnotifyPgpPublicKey publicKey) {
        super(session, publicKey);
    }

    @Override
    protected void encrypt(MimeMessage msg) throws IOException, MessagingException {
        PGPPublicKey encryptionKey = ((SnotifyPgpPublicKey)this.getPublicKey()).getKey();
        log.debug("Encrypting email with public key: {}", (Object)PgpUtil.getPrettyId(encryptionKey));
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        int encryptionAlgorithm = this.getSymmetricKeyAlgorithm();
        msg.addHeader("X-Encrypted", this.getXencryptedMailValue(encryptionAlgorithm));
        log.debug("Sender key: {}", this.getSenderKey());
        PGPPublicKey[] keys = this.addSenderEncryption() ? new PGPPublicKey[]{encryptionKey, ((SnotifyPgpPublicKey)this.getSenderKey().get()).getKey()} : new PGPPublicKey[]{encryptionKey};
        byte[] encryptedBytes = this.encrypt(msg, keys, encryptionAlgorithm);
        this.wrapIntoMessage(msg, encryptedBytes);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
        log.debug("Encrypting email successfully finished.");
    }

    private int getSymmetricKeyAlgorithm() {
        if (this.getForceSymmetricKeyAlgorithm() != -1) {
            return this.getForceSymmetricKeyAlgorithm();
        }
        if (!this.addSenderEncryption()) {
            return ((SnotifyPgpPublicKey)this.getPublicKey()).getSymmetricKeyAlgorithm();
        }
        int[] recipientAlgos = PgpUtil.getPreferredSymmetricKeyAlgorithms(((SnotifyPgpPublicKey)this.getPublicKey()).getKeyRing());
        int[] senderAlgos = PgpUtil.getPreferredSymmetricKeyAlgorithms(((SnotifyPgpPublicKey)this.getSenderKey().get()).getKeyRing());
        for (int recAlgo : recipientAlgos) {
            for (int senderAlgo : senderAlgos) {
                if (recAlgo != senderAlgo || !PgpUtil.isSupportedSymmetricKeyAlgorithm(recAlgo)) continue;
                log.debug("Found shared algorithm: {} ({})", (Object)PGPUtil.getSymmetricCipherName(recAlgo), (Object)recAlgo);
                return recAlgo;
            }
        }
        log.info("No supported algorithm shared between recipient and sender key. Using fallback of 3DES.");
        log.debug("Recipient/Sender Algorithms: {}/{}", (Object)Arrays.toString(recipientAlgos), (Object)Arrays.toString(senderAlgos));
        return 2;
    }

    private byte[] encrypt(MimeMessage msg, PGPPublicKey[] encryptionKeys, int encryptionAlgorithm) throws IOException, MessagingException {
        byte[] encryptedBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        try {
            encryptedBytes = PgpUtil.encrypt(baos.toByteArray(), encryptionKeys, encryptionAlgorithm, true, true);
        }
        catch (PGPException e) {
            throw new MessagingException(e.getLocalizedMessage(), (Exception)e);
        }
        return encryptedBytes;
    }

    private boolean addSenderEncryption() {
        return this.getSenderKey().isPresent() && ((SnotifyPgpPublicKey)this.getSenderKey().get()).isValid();
    }

    private void wrapIntoMessage(MimeMessage msg, byte[] encryptedBytes) throws IOException, MessagingException {
        MimeBodyPart partVersion = new MimeBodyPart();
        ByteArrayDataSource dsVersion = new ByteArrayDataSource("Version: 1\n", "application/pgp-encrypted");
        partVersion.setDataHandler(new DataHandler((DataSource)dsVersion));
        partVersion.setDescription("PGP/MIME version identification");
        MimeBodyPart partEncrypted = new MimeBodyPart();
        ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encryptedBytes, "application/octet-stream");
        partEncrypted.setDataHandler(new DataHandler((DataSource)dsEncrypted));
        partEncrypted.setDisposition("inline; filename=\"encrypted.asc\"");
        partEncrypted.setDescription("OpenPGP encrypted message");
        MimeMultipart multipart = new MimeMultipart("encrypted;\n\tprotocol=\"application/pgp-encrypted\"");
        multipart.addBodyPart((BodyPart)partVersion);
        multipart.addBodyPart((BodyPart)partEncrypted);
        msg.setContent((Multipart)multipart);
        msg.saveChanges();
    }

    protected String getXencryptedMailValue(int encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getSnotifyName(), this.getHostName(), PGPUtil.getSymmetricCipherName(encryptionAlgorithm));
    }

    public int getForceSymmetricKeyAlgorithm() {
        return this.forceSymmetricKeyAlgorithm;
    }

    public void setForceSymmetricKeyAlgorithm(int forceSymmetricKeyAlgorithm) {
        this.forceSymmetricKeyAlgorithm = forceSymmetricKeyAlgorithm;
    }
}

