/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.encrypt.AMailEncryptor;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailEncryptor
extends AMailEncryptor<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by {0} at {1} using S/MIME encryption with {2}";

    public SmimeMailEncryptor(Session session, SnotifySmimePublicKey publicKey) {
        super(session, publicKey);
    }

    @Override
    protected void encrypt(MimeMessage msg) throws IOException, MessagingException {
        OutputEncryptor encryptor;
        String usedEncryptionAlgorithm;
        log.debug("Encrypting email with certificate: {}", (Object)((SnotifySmimePublicKey)this.getPublicKey()).getKey());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.trace("Original email:\n{}\n", (Object)baos.toString());
        }
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        this.addRecipientEncryption(gen);
        this.addSenderEncryption(gen);
        try {
            log.debug("Using AES256_CBC algorithm for encryption.");
            usedEncryptionAlgorithm = "AES256_CBC";
            encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build();
        }
        catch (CMSException e) {
            if (e.getMessage().contains("Illegal key size")) {
                log.debug(e.getMessage(), (Throwable)e);
                log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. AES256_CBC encryption standard can not be used. Using fallback AES128_CBC encryption algorithm.");
                usedEncryptionAlgorithm = "AES128_CBC";
                try {
                    encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build();
                }
                catch (CMSException e1) {
                    throw new MessagingException("Could not create fallback content encryptor. Error message: " + e1.getMessage(), (Exception)e1);
                }
            }
            throw new MessagingException("Could not create content encryptor. Error message: " + e.getMessage(), (Exception)e);
        }
        this.encrypt(msg, gen, encryptor, usedEncryptionAlgorithm);
        msg.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.trace("Final email:\n{}\n", (Object)baos.toString());
        }
        log.debug("Encrypting email successfully finished.");
    }

    private void addRecipientEncryption(SMIMEEnvelopedGenerator gen) throws IOException, MessagingException {
        log.debug("Adding encryption information for recipient.");
        try {
            BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(((SnotifySmimePublicKey)this.getPublicKey()).getKey()));
            gen.addRecipientInfoGenerator(infoGenerator);
        }
        catch (CertificateEncodingException e) {
            throw new MessagingException("Could not use certificate for encryption. Error message: " + e.getMessage(), (Exception)e);
        }
    }

    private void addSenderEncryption(SMIMEEnvelopedGenerator gen) {
        log.debug("Sender key: {}", this.getSenderKey());
        if (this.getSenderKey().isPresent() && ((SnotifySmimePublicKey)this.getSenderKey().get()).isValid()) {
            log.debug("Adding encryption information for sender.");
            try {
                BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(((SnotifySmimePublicKey)this.getSenderKey().get()).getKey()));
                gen.addRecipientInfoGenerator(infoGenerator);
            }
            catch (Exception e) {
                log.error("Could not use sender certificate for encryption. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void encrypt(MimeMessage msg, SMIMEEnvelopedGenerator gen, OutputEncryptor encryptor, String usedEncryptionAlgorithm) throws IOException, MessagingException {
        MimeBodyPart encryptedBody;
        log.debug("Encrypting content.");
        try {
            if (msg.getContent() instanceof MimeBodyPart || msg.getContent() instanceof MimeMultipart) {
                encryptedBody = gen.generate(msg, encryptor);
            } else {
                MimeBodyPart part = new MimeBodyPart();
                MessageUtil.copyAllHeaders((Part)msg, (Part)part);
                part.setContent(msg.getContent(), msg.getContentType());
                encryptedBody = gen.generate(part, encryptor);
            }
        }
        catch (SMIMEException e) {
            throw new MessagingException("Could not encrypt email. Error Message: " + e.getMessage(), (Exception)e);
        }
        msg.setContent(encryptedBody.getContent(), encryptedBody.getContentType());
        MessageUtil.copyAllHeaders((Part)encryptedBody, (Part)msg);
        msg.addHeader("X-Encrypted", this.getXencryptedMailValue(usedEncryptionAlgorithm));
    }

    protected String getXencryptedMailValue(String encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getSnotifyName(), this.getHostName(), encryptionAlgorithm);
    }
}

