/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyLoader<T extends ISnotifyKey<?>>
implements IKeyLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(AKeyLoader.class);

    @Override
    public T loadKey() {
        T key = null;
        try {
            key = this.loadInternalKey();
        }
        catch (Exception e) {
            log.error("Could not load key. Error message: " + e.getMessage(), (Throwable)e);
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.ERROR);
        }
        return key;
    }

    protected abstract T loadInternalKey() throws Exception;

    protected abstract T getValidityKey(EKeyValidity var1);
}

