/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APublicKeyManager<T extends ISnotifyPublicKey<?>>
extends AKeyManager<T> {
    private static final Logger log = LoggerFactory.getLogger(APublicKeyManager.class);
    public static final long EXPIRE_DURATION = 43200000L;
    private final IUser<?> user;
    private final ISnotifyUserProperties userProps;
    private final EProperty keyTimeStampProp;
    private T cachedPublicKey;

    public APublicKeyManager(String address, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(address, appProps);
        if (appProps == null) {
            throw new IllegalArgumentException("Application properties must not be null.");
        }
        if (userProps == null) {
            throw new IllegalArgumentException("User properties must not be null.");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address must not be null.");
        }
        this.userProps = userProps;
        this.user = null;
        this.keyTimeStampProp = null;
    }

    public APublicKeyManager(IUser<?> user, EProperty keyTimeStampProp, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(user.getEmail(), appProps);
        if (keyTimeStampProp == null) {
            throw new IllegalArgumentException("Time stamp propertie must not be null.");
        }
        if (appProps == null) {
            throw new IllegalArgumentException("Application properties must not be null.");
        }
        if (userProps == null) {
            throw new IllegalArgumentException("User properties must not be null.");
        }
        this.user = user;
        this.userProps = userProps;
        this.keyTimeStampProp = keyTimeStampProp;
    }

    @Override
    public T getKey() {
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE)) {
            log.debug("Loading key from user location, as light version is detected.");
            ISnotifyKey key = this.getCachedKey();
            if (key.getKeySource() != EKeySource.USER) {
                key = (ISnotifyPublicKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.USER);
            }
            log.debug("User key for address {}: {}", (Object)this.getAddress(), (Object)key);
            return (T)key;
        }
        return (T)((ISnotifyPublicKey)super.getKey());
    }

    @Override
    protected T getCachedKey() {
        if (this.cachedPublicKey == null) {
            this.cachedPublicKey = this.loadCachedPublicKey();
        }
        return this.cachedPublicKey;
    }

    @Override
    protected abstract void setCachedKey(T var1) throws IOException;

    @Override
    protected boolean isCacheAutomaticallyExpired() {
        if (super.isCacheAutomaticallyExpired()) {
            return true;
        }
        if (this.getUser() == null) {
            log.trace("No user given.");
            return false;
        }
        if (this.getCachedKey().getKeySource() == EKeySource.USER) {
            log.trace("User uploaded keys never expire automatically.");
            return false;
        }
        if (this.getCachedKey().getKeySource() == EKeySource.EMAIL) {
            log.trace("Email received keys never expire automatically.");
            return false;
        }
        Long cachedTimeStamp = this.getUserProps().getLong(this.keyTimeStampProp, this.getUser());
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (System.currentTimeMillis() > cachedTimeStamp + 43200000L) {
            log.debug("Cache automatically expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired() {
        if (super.isCacheManuallyExpired()) {
            return true;
        }
        if (this.getUser() == null) {
            log.trace("No user given.");
            return false;
        }
        if (this.getCachedKey().getKeySource() == EKeySource.USER) {
            log.trace("User uploaded keys never expire manually.");
            return false;
        }
        if (this.getCachedKey().getKeySource() == EKeySource.EMAIL) {
            log.trace("User uploaded keys never expire manually.");
            return false;
        }
        Long cachedTimeStamp = this.getUserProps().getLong(this.keyTimeStampProp, this.getUser());
        Long expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP);
        if (cachedTimeStamp != null && expireTimeStamp != null && expireTimeStamp > cachedTimeStamp) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCachedKeyUsable(T key) {
        if (!super.isCachedKeyUsable(key)) {
            return false;
        }
        if (this.getUser() == null) {
            log.debug("Cached key unusable: No user.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isKeyCachable(T key) {
        if (!super.isKeyCachable(key)) {
            return false;
        }
        if (this.getUser() == null) {
            log.debug("Not cachable: No user.");
            return false;
        }
        if (key.getKeySource() == EKeySource.USER) {
            log.debug("Not cachable: User key.");
            return false;
        }
        return true;
    }

    protected abstract T loadCachedPublicKey();

    public IUser<?> getUser() {
        return this.user;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }
}

