/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyServerLoader
extends AKeyLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpKeyServerLoader.class);
    private static final String HEADER_FIELD_LOCATION = "Location";
    private final String keyServer;
    private final String email;
    private boolean encodeSearchParam = true;
    private int timeout = 20000;

    public PgpKeyServerLoader(String keyServer, String email) {
        this.keyServer = keyServer;
        this.email = email;
        if (keyServer == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        Set<String> keyIds;
        log.info("Looking up public key for email {} from: {}", (Object)this.getEmail(), (Object)this.keyServer);
        try {
            keyIds = this.getKeyIdsFromServer(this.keyServer, "<" + this.getEmail().toLowerCase(Locale.ROOT) + ">");
        }
        catch (IOException e) {
            log.warn("Error retrieving public key from key server for email: " + this.getEmail(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        if (keyIds.isEmpty()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        List<SnotifyPgpPublicKey> keys = this.getKeysFromServer(this.keyServer, keyIds);
        SnotifyPgpPublicKey key = this.getNewestKey(keys);
        if (key.getKeyValidity() == EKeyValidity.VALID) {
            log.info("Found public key for email {} with ID: {}", (Object)this.getEmail(), (Object)PgpUtil.getPrettyId(key.getMasterKey()));
        } else {
            log.info("No public key found for email: {}", (Object)this.getEmail());
        }
        return key;
    }

    private Set<String> getKeyIdsFromServer(String baseUrl, String searchFor) throws IOException {
        log.debug("Looking up public key for {} from: {}", (Object)searchFor, (Object)baseUrl);
        URL url = this.createUrl(baseUrl, searchFor, "index", this.isEncodeSearchParam());
        return this.getKeyIdsFromServer(url, searchFor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyIdsFromServer(URL url, String searchFor) throws IOException {
        Set<String> keyIds;
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(url);
            log.debug("Connecting to: {}", (Object)connection.getURL());
            connection.connect();
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            log.debug("Response code for key server {} : {} ({})", new Object[]{url.getHost(), responseCode, responseMessage});
            if (responseCode >= 200 && responseCode < 300) {
                log.debug("Found public key(s) for: {}", (Object)searchFor);
                keyIds = this.getKeyIdsFromServer(connection, searchFor);
            } else if (responseCode >= 300 && responseCode < 400 && connection.getHeaderField(HEADER_FIELD_LOCATION) != null) {
                String newLocation = connection.getHeaderField(HEADER_FIELD_LOCATION);
                log.debug("Redirect to new location: {}", (Object)newLocation);
                keyIds = this.getKeyIdsFromServer(new URL(newLocation), searchFor);
            } else if (responseCode == 404) {
                log.debug("No public key found for: {}", (Object)searchFor);
                keyIds = Collections.emptySet();
            } else {
                log.error("Connecting to key server \"{}\" not successful. Server returned response code {}: {}", new Object[]{url, responseCode, responseMessage});
                if (log.isDebugEnabled()) {
                    log.debug("Headers: {}", connection.getHeaderFields());
                }
                keyIds = Collections.emptySet();
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (keyIds.isEmpty()) {
            log.debug("No public key found for: {}", (Object)searchFor);
        } else {
            log.debug("Key IDs found for {}: {}", (Object)searchFor, keyIds);
        }
        return keyIds;
    }

    private Set<String> getKeyIdsFromServer(HttpURLConnection connection, String searchFor) throws IOException {
        HashSet<String> keyIds = new HashSet<String>();
        try (InputStream is = connection.getInputStream();){
            long currentTime = System.currentTimeMillis() / 1000L;
            String keyId = null;
            boolean skipToNextKey = false;
            String encoding = connection.getContentEncoding();
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
            while (lineIterator.hasNext()) {
                String[] parts;
                String line = URLDecoder.decode(lineIterator.nextLine(), "UTF-8").toLowerCase(Locale.ROOT);
                log.trace(line);
                if (line.startsWith("pub:")) {
                    skipToNextKey = true;
                    keyId = null;
                    parts = line.split(":", 7);
                    if (parts.length != 7) continue;
                    keyId = parts[1];
                    String expirationDate = parts[5];
                    String flags = parts[6];
                    boolean validKey = flags.isEmpty() || expirationDate.isEmpty() || Long.parseLong(expirationDate) > currentTime;
                    skipToNextKey = !validKey;
                    continue;
                }
                if (skipToNextKey || !line.startsWith("uid:") || (parts = line.split(":", 5)).length != 5 || !parts[1].contains(searchFor)) continue;
                log.info("Found matching public key for {} with ID: {}", (Object)searchFor, (Object)keyId);
                keyIds.add(keyId);
            }
        }
        return keyIds;
    }

    private List<SnotifyPgpPublicKey> getKeysFromServer(String baseUrl, Collection<String> keyIds) {
        ArrayList<SnotifyPgpPublicKey> keys = new ArrayList<SnotifyPgpPublicKey>(keyIds.size());
        for (String keyId : keyIds) {
            PGPPublicKeyRing key = null;
            try {
                key = this.getKeyFromServer(baseUrl, keyId);
            }
            catch (IOException e) {
                log.warn("Error retrieving public key with ID " + keyId + " from keyserver for email: " + this.getEmail(), (Throwable)e);
            }
            if (key == null) continue;
            SnotifyPgpPublicKey pgpKey = new SnotifyPgpPublicKey(key, this.getEmail());
            pgpKey.setKeySource(this.getKeySource());
            keys.add(pgpKey);
        }
        return keys;
    }

    private PGPPublicKeyRing getKeyFromServer(String baseUrl, String keyId) throws IOException {
        log.debug("Looking up pulic key with ID: " + keyId);
        URL url = this.createUrl(baseUrl, "0x" + keyId, "get", false);
        return this.getKeyFromServer(url, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPPublicKeyRing getKeyFromServer(URL url, String keyId) throws IOException {
        PGPPublicKeyRing keyRing;
        block22: {
            HttpURLConnection connection = null;
            try {
                connection = this.createConnection(url);
                log.debug("Connecting to: {}", (Object)connection.getURL());
                connection.connect();
                int responseCode = connection.getResponseCode();
                String responseMessage = connection.getResponseMessage();
                log.debug("Response code for key server {} : {} ({})", new Object[]{url.getHost(), responseCode, responseMessage});
                if (responseCode >= 200 && responseCode < 300) {
                    log.debug("Found public key for key ID: {}", (Object)keyId);
                    try (InputStream is = connection.getInputStream();){
                        keyRing = PgpUtil.loadPublicKey(is);
                        break block22;
                    }
                }
                if (responseCode >= 300 && responseCode < 400 && connection.getHeaderField(HEADER_FIELD_LOCATION) != null) {
                    String newLocation = connection.getHeaderField(HEADER_FIELD_LOCATION);
                    log.debug("Redirect to new location: {}", (Object)newLocation);
                    keyRing = this.getKeyFromServer(new URL(newLocation), keyId);
                } else if (responseCode == 404) {
                    log.debug("No public key found for key ID: {}", (Object)keyId);
                    keyRing = null;
                } else {
                    log.error("Could not retrieve key with key ID {} from key server \"{}\". Server returned response code {}: {}", new Object[]{keyId, url, responseCode, responseMessage});
                    if (log.isDebugEnabled()) {
                        log.debug("Headers: {}", connection.getHeaderFields());
                    }
                    keyRing = null;
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return keyRing;
    }

    private SnotifyPgpPublicKey getNewestKey(Collection<SnotifyPgpPublicKey> keys) {
        EKeyValidity fallbackValidity = EKeyValidity.ERROR;
        long newestCreationTime = 0L;
        SnotifyPgpPublicKey newestKey = null;
        for (SnotifyPgpPublicKey key : keys) {
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                PGPPublicKey encKey = key.getKey();
                if (encKey.getCreationTime().getTime() <= newestCreationTime) continue;
                newestCreationTime = encKey.getCreationTime().getTime();
                newestKey = key;
                continue;
            }
            fallbackValidity = key.getKeyValidity();
        }
        if (newestKey != null && log.isDebugEnabled()) {
            PGPPublicKey encKey = newestKey.getKey();
            PGPPublicKey masterKey = newestKey.getMasterKey();
            String prettyEncKeyId = PgpUtil.getPrettyId(encKey);
            String prettyMasterKeyId = PgpUtil.getPrettyId(masterKey);
            log.debug("Most current key (ID: {}, Master Key ID: {}). Creation time: {}", new Object[]{prettyEncKeyId, prettyMasterKeyId, encKey.getCreationTime()});
        } else if (newestKey == null) {
            log.debug("Could not find a valid key. Most likely explanation: {}", (Object)fallbackValidity);
            newestKey = this.getValidityKey(fallbackValidity);
        }
        return newestKey;
    }

    protected URL createUrl(String baseUrl, String searchFor, String operation, boolean encode) throws UnsupportedEncodingException, MalformedURLException {
        String basePath = "pks/lookup";
        String searchArg = "search";
        String operationArg = "op";
        String options = "options=mr";
        String exact = "exact=on";
        StringBuilder builder = new StringBuilder(1000);
        boolean hkpFound = baseUrl.startsWith("hkp");
        if (hkpFound) {
            hkpFound = true;
            builder.append("http");
            builder.append(baseUrl.substring(3));
        } else {
            builder.append(baseUrl);
        }
        if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append("pks/lookup");
        builder.append('?');
        builder.append("options=mr");
        builder.append('&');
        builder.append("exact=on");
        builder.append('&');
        builder.append("op");
        builder.append('=');
        builder.append(operation);
        builder.append('&');
        builder.append("search");
        builder.append('=');
        builder.append(encode ? URLEncoder.encode(searchFor, "UTF-8") : searchFor);
        URL url = new URL(builder.toString());
        if (hkpFound && url.getPort() == -1) {
            int port = url.getProtocol().equals("http") ? 11371 : 443;
            return new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        }
        return url;
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        log.debug("Creating connection for URL: {}", (Object)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(false);
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        return connection;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSERVER;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    public String getKeyServerUrl() {
        return this.keyServer;
    }

    public String getEmail() {
        return this.email;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isEncodeSearchParam() {
        return this.encodeSearchParam;
    }

    public void setEncodeSearchParam(boolean encodeSearchParam) {
        this.encodeSearchParam = encodeSearchParam;
    }

    public String toString() {
        return "PgpKeyServerLoader [keyServer=" + this.keyServer + ", email=" + this.email + ", encodeSearchParam=" + this.encodeSearchParam + ", timeout=" + this.timeout + "]";
    }
}

