/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpSignKeyStoreLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpSignKeyManager
extends APrivateKeyManager<SnotifyPgpSignKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpSignKeyManager.class);

    public PgpSignKeyManager(String address, ISnotifyAppProperties appProps) {
        super(address, appProps);
    }

    @Override
    protected List<Supplier<Optional<IKeyLoader<SnotifyPgpSignKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpSignKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpSignKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifyPgpSignKey>> createKeyStoreLoader() {
        PGPSecretKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP private keys from.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_PGP_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_PGP_KEY_PASSWORD)) {
            log.error("Error retrieving password for PGP private key.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadSecretKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpSignKeyStoreLoader(keyRings, keyPassword, this.getAddress()));
    }

    @Override
    protected SnotifyPgpSignKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifyPgpSignKey(validity, keySource);
    }

    @Override
    protected Class<SnotifyPgpSignKey> getCacheClass() {
        return SnotifyPgpSignKey.class;
    }
}

