/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeCertificateKeyStoreLoader
extends AKeyLoader<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeCertificateKeyStoreLoader.class);
    private final KeyStore keyStore;
    private final String email;

    public SmimeCertificateKeyStoreLoader(KeyStore keyStore, String email) {
        this.keyStore = keyStore;
        this.email = email;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    protected SnotifySmimePublicKey loadInternalKey() throws Exception {
        log.info("Looking up S/MIME certificate for email {} in key store.", (Object)this.getEmail());
        X509Certificate certificate = SmimeUtil.getValidCertForEmail(this.getKeyStore(), this.getEmail(), EKeyPurpose.ENCRYPTION);
        if (certificate != null) {
            log.info("Found valid S/MIME certificate for email {} in key store.", (Object)this.getEmail());
            log.trace("Found certificate: {}", (Object)certificate);
            SnotifySmimePublicKey key = new SnotifySmimePublicKey(certificate, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        try {
            certificate = SmimeUtil.getCertForEmail(this.getKeyStore(), this.getEmail());
        }
        catch (KeyStoreException | CertificateException e) {
            log.warn("Could not load certificate from key store for email " + this.getEmail() + ".", (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found no valid S/MIME certificate for email {} in key store.", (Object)this.getEmail());
        log.trace("Found certificate: {}", (Object)certificate);
        SnotifySmimePublicKey key = certificate == null ? new SnotifySmimePublicKey(EKeyValidity.NOT_FOUND) : new SnotifySmimePublicKey(certificate);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "SmimeCertificateKeyStoreLoader [keyStore=" + this.keyStore + ", email=" + this.email + "]";
    }
}

