/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.security.KeyStore;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeCertificateP7bLoader
extends AKeyLoader<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeCertificateP7bLoader.class);
    private final Store<X509CertificateHolder> keyStore;
    private final String email;

    public SmimeCertificateP7bLoader(Store<X509CertificateHolder> keyStore, String email) {
        this.keyStore = keyStore;
        this.email = email;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    protected SnotifySmimePublicKey loadInternalKey() throws Exception {
        log.info("Looking up S/MIME certificate for email {} in P7B store.", (Object)this.getEmail());
        KeyStore convertedKeyStore = SmimeUtil.convertToKeyStore(this.getKeyStore(), "BKS", null);
        SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(convertedKeyStore, this.getEmail());
        return (SnotifySmimePublicKey)loader.loadKey();
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }

    public Store<X509CertificateHolder> getKeyStore() {
        return this.keyStore;
    }

    public String getEmail() {
        return this.email;
    }
}

