/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeCertificateKeyStoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeEncryptionKeyManager
extends AKeyManager<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeEncryptionKeyManager.class);
    private static final Map<String, SnotifySmimePublicKey> keyCache = new HashMap<String, SnotifySmimePublicKey>();
    private static final Map<String, Calendar> timeCache = new HashMap<String, Calendar>();

    public SmimeEncryptionKeyManager(String address, ISnotifyAppProperties appProps) {
        super(address, appProps);
    }

    @Override
    protected SnotifySmimePublicKey getCachedKey() {
        return keyCache.getOrDefault(this.getAddress(), this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(SnotifySmimePublicKey key) throws IOException {
        if (key != null) {
            keyCache.put(this.getAddress(), key);
        } else {
            keyCache.remove(this.getAddress());
        }
        timeCache.put(this.getAddress(), Calendar.getInstance());
    }

    @Override
    protected boolean isCacheAutomaticallyExpired() {
        if (super.isCacheAutomaticallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != this.getCachedTimeStamp().get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired() {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > this.getCachedTimeStamp().getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected Iterable<Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No private key store specified. Can't get decryption from key store.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            SecurityUtil.clearPassword(keyPassword);
            log.debug("Loaded key store from location \"{}\" succesfully.", (Object)location);
            return Optional.of(new SmimeCertificateKeyStoreLoader(ks, this.getAddress()));
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifySmimePublicKey(validity, keySource);
    }

    protected Calendar getCachedTimeStamp() {
        return timeCache.get(this.getAddress());
    }

    protected void setCachedTimeStamp(Calendar cachedTimeStamp) {
        timeCache.put(this.getAddress(), cachedTimeStamp);
    }
}

